/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.jdbcclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.jdbcclient.JDBCConnection.class)
public class JDBCConnection extends io.vertx.reactivex.sqlclient.SqlConnection implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCConnection that = (JDBCConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCConnection> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCConnection((io.vertx.jdbcclient.JDBCConnection) obj),
    JDBCConnection::getDelegate
  );

  private final io.vertx.jdbcclient.JDBCConnection delegate;
  
  public JDBCConnection(io.vertx.jdbcclient.JDBCConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCConnection(Object delegate) {
    super((io.vertx.jdbcclient.JDBCConnection)delegate);
    this.delegate = (io.vertx.jdbcclient.JDBCConnection)delegate;
  }

  @Override 
  public io.vertx.jdbcclient.JDBCConnection getDelegate() {
    return delegate;
  }


  public io.vertx.core.Future<java.lang.Integer> getTransactionIsolation() { 
    io.vertx.core.Future<java.lang.Integer> ret = delegate.getTransactionIsolation().map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.Integer> rxGetTransactionIsolation() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getTransactionIsolation().onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.Void> setTransactionIsolation(int isolationLevel) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.setTransactionIsolation(isolationLevel).map(val -> val);
    return ret;
  }

  public io.reactivex.Completable rxSetTransactionIsolation(int isolationLevel) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.setTransactionIsolation(isolationLevel).onComplete($handler);
    });
  }

  /**
   * Sets a connection wide query timeout.
   *
   * It can be over-written at any time and becomes active on the next query call.
   * @param timeoutInSeconds the max amount of seconds the query can take to execute.
   * @return 
   */
  public io.vertx.reactivex.jdbcclient.JDBCConnection setQueryTimeout(int timeoutInSeconds) { 
    delegate.setQueryTimeout(timeoutInSeconds);
    return this;
  }

  public static JDBCConnection newInstance(io.vertx.jdbcclient.JDBCConnection arg) {
    return arg != null ? new JDBCConnection(arg) : null;
  }

}
