/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.server;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.grpc.server.GrpcServerRequest.class)
public class GrpcServerRequest<Req,Resp> extends io.vertx.reactivex.grpc.common.GrpcReadStream<Req> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServerRequest that = (GrpcServerRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServerRequest> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServerRequest((io.vertx.grpc.server.GrpcServerRequest) obj),
    GrpcServerRequest::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServerRequest<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcServerRequest(io.vertx.grpc.server.GrpcServerRequest delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcServerRequest(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.server.GrpcServerRequest)delegate);
    this.delegate = (io.vertx.grpc.server.GrpcServerRequest)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.grpc.server.GrpcServerRequest getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<Req> observable;
  private io.reactivex.Flowable<Req> flowable;

  public synchronized io.reactivex.Observable<Req> toObservable() {
    if (observable == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.wrap;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<Req> toFlowable() {
    if (flowable == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.wrap;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<Req> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<Req> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), __typeArg_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<Req> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Req> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * @return the last element of the stream
   */
  public io.vertx.core.Future<Req> last() { 
    io.vertx.core.Future<Req> ret = delegate.last().map(val -> (Req)__typeArg_0.wrap(val));
    return ret;
  }

  /**
   * @return the last element of the stream
   */
  public io.reactivex.Single<Req> rxLast() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.last().onComplete($handler);
    });
  }

  /**
   * @return the service name
   */
  public io.vertx.grpc.common.ServiceName serviceName() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.grpc.common.ServiceName ret = delegate.serviceName();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the method name
   */
  public java.lang.String methodName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.methodName();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return the full method name sent by the client
   */
  public java.lang.String fullMethodName() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.fullMethodName();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the response
   */
  public io.vertx.reactivex.grpc.server.GrpcServerResponse<Req,Resp> response() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.reactivex.grpc.server.GrpcServerResponse<Req,Resp> ret = io.vertx.reactivex.grpc.server.GrpcServerResponse.newInstance((io.vertx.grpc.server.GrpcServerResponse)delegate.response(), __typeArg_0, __typeArg_1);
    cached_3 = ret;
    return ret;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> messageHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcMessage> handler) { 
    delegate.messageHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> errorHandler(io.vertx.core.Handler<io.vertx.grpc.common.GrpcError> handler) { 
    delegate.errorHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> handler(io.vertx.core.Handler<Req> handler) { 
    delegate.handler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> (Req)__typeArg_0.wrap(event)));
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return the underlying HTTP connection
   */
  public io.vertx.reactivex.core.http.HttpConnection connection() { 
    io.vertx.reactivex.core.http.HttpConnection ret = io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the request timeout sent by the client or <code>0L</code> if none.
   */
  public long timeout() { 
    long ret = delegate.timeout();
    return ret;
  }

  /**
   * @return the request deadline or <code>null</code> when no deadline has been scheduled
   */
  public io.vertx.reactivex.core.Timer deadline() { 
    io.vertx.reactivex.core.Timer ret = io.vertx.reactivex.core.Timer.newInstance((io.vertx.core.Timer)delegate.deadline());
    return ret;
  }

  /**
   * Set a message handler that is reported with invalid message errors.
   *
   * <p>Warning: setting this handler overwrite the default handler which takes appropriate measure
   * when an invalid message is encountered such as cancelling the stream. This handler should be set
   * when control over invalid messages is required.</p>
   * @param handler the invalid message handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.common.GrpcReadStream<Req> invalidMessageHandler(io.vertx.core.Handler<io.vertx.grpc.common.InvalidMessageException> handler) { 
    io.vertx.reactivex.grpc.common.GrpcReadStream<Req> ret = io.vertx.reactivex.grpc.common.GrpcReadStream.newInstance((io.vertx.grpc.common.GrpcReadStream)delegate.invalidMessageHandler(handler), __typeArg_0);
    return ret;
  }

  private io.vertx.grpc.common.ServiceName cached_0;
  private java.lang.String cached_1;
  private java.lang.String cached_2;
  private io.vertx.reactivex.grpc.server.GrpcServerResponse<Req,Resp> cached_3;
  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcServerRequest<Req,Resp> newInstance(io.vertx.grpc.server.GrpcServerRequest arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcServerRequest<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
