/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.server;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>A gRPC server based on Vert.x HTTP server.</p>
 *
 * <p>The server can be used as a {@link io.vertx.reactivex.core.http.HttpServer} handler or mounted as a Vert.x Web handler.</p>
 *
 * <p>Unlike traditional gRPC servers, this server does not rely on a generated RPC interface to interact with the service.</p>
 *
 * <p>Instead, you can interact with the service with a request/response interfaces and gRPC messages, very much like
 * a traditional client.</p>
 *
 * <p>The server handles only the gRPC protocol and does not encode/decode protobuf messages.</p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.server.GrpcServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.server.GrpcServer.class)
public class GrpcServer implements RxDelegate, Handler<io.vertx.reactivex.core.http.HttpServerRequest> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcServer that = (GrpcServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcServer> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcServer((io.vertx.grpc.server.GrpcServer) obj),
    GrpcServer::getDelegate
  );

  private final io.vertx.grpc.server.GrpcServer delegate;
  
  public GrpcServer(io.vertx.grpc.server.GrpcServer delegate) {
    this.delegate = delegate;
  }

  public GrpcServer(Object delegate) {
    this.delegate = (io.vertx.grpc.server.GrpcServer)delegate;
  }

  @Override 
  public io.vertx.grpc.server.GrpcServer getDelegate() {
    return delegate;
  }


  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.core.http.HttpServerRequest event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a blank gRPC server with default options.
   * @param vertx 
   * @return the created server
   */
  public static io.vertx.reactivex.grpc.server.GrpcServer server(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.grpc.server.GrpcServer ret = io.vertx.reactivex.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)io.vertx.grpc.server.GrpcServer.server(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a blank gRPC server with specified options.
   * @param vertx 
   * @param options the gRPC server options
   * @return the created server
   */
  public static io.vertx.reactivex.grpc.server.GrpcServer server(io.vertx.reactivex.core.Vertx vertx, io.vertx.grpc.server.GrpcServerOptions options) { 
    io.vertx.reactivex.grpc.server.GrpcServer ret = io.vertx.reactivex.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)io.vertx.grpc.server.GrpcServer.server(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set a call handler that handles any call made to the server.
   * @param handler the service method call handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.server.GrpcServer callHandler(io.vertx.core.Handler<io.vertx.reactivex.grpc.server.GrpcServerRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> handler) { 
    delegate.callHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, TypeArg.unknown(), TypeArg.unknown())));
    return this;
  }

  /**
   * Set a service method call handler that handles any call made to the server for the <code>fullMethodName</code> service method.
   * @param serviceMethod the service method
   * @param handler the service method call handler
   * @return a reference to this, so the API can be used fluently
   */
  public <Req, Resp> io.vertx.reactivex.grpc.server.GrpcServer callHandler(io.vertx.grpc.common.ServiceMethod<Req,Resp> serviceMethod, io.vertx.core.Handler<io.vertx.reactivex.grpc.server.GrpcServerRequest<Req,Resp>> handler) { 
    io.vertx.reactivex.grpc.server.GrpcServer ret = io.vertx.reactivex.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)delegate.callHandler(serviceMethod, io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, TypeArg.unknown(), TypeArg.unknown()))));
    return ret;
  }

  /**
   * Add a service to this gRPC server.
   * <p>
   * This method registers a service with the server, allowing it to handle requests for that service.
   * Each service must have a unique name.
   * @param service the service to add
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.server.GrpcServer addService(io.vertx.grpc.server.Service service) { 
    io.vertx.reactivex.grpc.server.GrpcServer ret = io.vertx.reactivex.grpc.server.GrpcServer.newInstance((io.vertx.grpc.server.GrpcServer)delegate.addService(service));
    return ret;
  }

  /**
   * Get a list of all services registered with this gRPC server.
   * @return an unmodifiable list of all registered services
   */
  public java.util.List<io.vertx.grpc.server.Service> services() { 
    java.util.List<io.vertx.grpc.server.Service> ret = delegate.services();
    return ret;
  }

  public static GrpcServer newInstance(io.vertx.grpc.server.GrpcServer arg) {
    return arg != null ? new GrpcServer(arg) : null;
  }

}
