/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A request to a gRPC server.
 *
 * <p>You interact with the remote service with gRPC generated messages or protobuf encoded messages.
 *
 * <p>Before sending a request you need to set {@link io.vertx.reactivex.grpc.client.GrpcClientRequest #serviceName)} and {@link io.vertx.reactivex.grpc.client.GrpcClientRequest #methodName)} or
 * alternatively the service {@link io.vertx.reactivex.grpc.client.GrpcClientRequest#fullMethodName}.
 *
 * <p>Writing a request message will send the request to the service:
 *
 * <ul>
 *   <li>To send a unary request, just call </li>
 *   <li>To send a streaming request, call  any time you need and then {@link io.vertx.reactivex.core.streams.WriteStream#end}</li>
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClientRequest original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClientRequest.class)
public class GrpcClientRequest<Req,Resp> extends io.vertx.reactivex.grpc.common.GrpcWriteStream<Req> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClientRequest that = (GrpcClientRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClientRequest> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClientRequest((io.vertx.grpc.client.GrpcClientRequest) obj),
    GrpcClientRequest::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClientRequest<Req,Resp> delegate;
  public final TypeArg<Req> __typeArg_0;
  public final TypeArg<Resp> __typeArg_1;
  
  public GrpcClientRequest(io.vertx.grpc.client.GrpcClientRequest delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public GrpcClientRequest(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
    super((io.vertx.grpc.client.GrpcClientRequest)delegate);
    this.delegate = (io.vertx.grpc.client.GrpcClientRequest)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.grpc.client.GrpcClientRequest getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<Req> observer;
  private WriteStreamSubscriber<Req> subscriber;

  public synchronized WriteStreamObserver<Req> toObserver() {
    if (observer == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.unwrap;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<Req> toSubscriber() {
    if (subscriber == null) {
      Function<Req, Req> conv = (Function<Req, Req>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.vertx.core.Future<java.lang.Void> write(Req data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(__typeArg_0.<Req>unwrap(data)).map(val -> val);
    return ret;
  }

  /**
   * Write some data to the stream.
   *
   * <p> The data is usually put on an internal write queue, and the write actually happens
   * asynchronously. To avoid running out of memory by putting too much on the write queue,
   * check the {@link io.vertx.reactivex.core.streams.WriteStream#writeQueueFull} method before writing. This is done automatically if
   * using a .
   *
   * <p> When the <code>data</code> is moved from the queue to the actual medium, the returned
   *  will be completed with the write result, e.g the future is succeeded
   * when a server HTTP response buffer is written to the socket and failed if the remote
   * client has closed the socket while the data was still pending for write.
   * @param data the data to write
   * @return a future completed with the write result
   */
  public io.reactivex.Completable rxWrite(Req data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Ends the stream.
   * <p>
   * Once the stream has ended, it cannot be used any more.
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(Req data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(__typeArg_0.<Req>unwrap(data)).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.core.streams.WriteStream#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(Req data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.grpc.client.GrpcClientRequest#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> encoding(java.lang.String encoding) { 
    delegate.encoding(encoding);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> format(io.vertx.grpc.common.WireFormat format) { 
    delegate.format(format);
    return this;
  }

  /**
   * Set the full method name to call, it must follow the format <code>package-name + '.' + service-name + '/' + method-name</code>
   * or an <code>IllegalArgumentException</code> is thrown.
   *
   * <p> It must be called before sending the request otherwise an <code>IllegalStateException</code> is thrown.
   * @param fullMethodName the full method name to call
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> fullMethodName(java.lang.String fullMethodName) { 
    delegate.fullMethodName(fullMethodName);
    return this;
  }

  /**
   * Set the service name to call.
   *
   * <p> It must be called before sending the request otherwise an <code>IllegalStateException</code> is thrown.
   * @param serviceName the service name to call
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> serviceName(io.vertx.grpc.common.ServiceName serviceName) { 
    delegate.serviceName(serviceName);
    return this;
  }

  /**
   * Set the method name to call.
   *
   * <p> It must be called before sending the request otherwise an <code>IllegalStateException</code> is thrown.
   * @param methodName the method name to call
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> methodName(java.lang.String methodName) { 
    delegate.methodName(methodName);
    return this;
  }

  /**
   * @return the gRPC response
   */
  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> response() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> ret = delegate.response().map(val -> io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)val, __typeArg_0, __typeArg_1));
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the gRPC response
   */
  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> rxResponse() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.response().onComplete($handler);
    });
  }

  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * <p>Set a <code>grpc-timeout</code> header to be sent to the server to indicate the client expects a response with
   * a timeout.</p>
   *
   * <p>When the request handle deadline a timer will be set when sending the request to cancel the request when the response
   * has not been received in time.</p>
   * @param timeout 
   * @param unit 
   * @return 
   */
  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> timeout(long timeout, java.util.concurrent.TimeUnit unit) { 
    delegate.timeout(timeout, unit);
    return this;
  }

  /**
   * @return the request deadline or <code>null</code> when no deadline has been scheduled
   */
  public io.vertx.reactivex.core.Timer deadline() { 
    io.vertx.reactivex.core.Timer ret = io.vertx.reactivex.core.Timer.newInstance((io.vertx.core.Timer)delegate.deadline());
    return ret;
  }

  /**
   * Sets the amount of time after which, if the request does not return any data within the timeout period,
   * the request/response is cancelled and the related futures.
   * @param timeout the amount of time in milliseconds.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp> idleTimeout(long timeout) { 
    delegate.idleTimeout(timeout);
    return this;
  }

  /**
   * @return the underlying HTTP connection
   */
  public io.vertx.reactivex.core.http.HttpConnection connection() { 
    io.vertx.reactivex.core.http.HttpConnection ret = io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)delegate.connection());
    return ret;
  }

  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> send(Req item) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> ret = delegate.send(__typeArg_0.<Req>unwrap(item)).map(val -> io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)val, __typeArg_0, __typeArg_1));
    return ret;
  }

  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> rxSend(Req item) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.send(item).onComplete($handler);
    });
  }

  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> send(io.vertx.reactivex.core.streams.ReadStream<Req> body) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> ret = delegate.send(body.getDelegate()).map(val -> io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)val, __typeArg_0, __typeArg_1));
    return ret;
  }

  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> rxSend(io.vertx.reactivex.core.streams.ReadStream<Req> body) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.send(body).onComplete($handler);
    });
  }

  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> send(io.reactivex.Flowable<Req> body) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> ret = delegate.send(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(body, obj -> __typeArg_0.<Req>unwrap(obj)).resume()).map(val -> io.vertx.reactivex.grpc.client.GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)val, __typeArg_0, __typeArg_1));
    return ret;
  }

  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> rxSend(io.reactivex.Flowable<Req> body) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.send(body).onComplete($handler);
    });
  }

  private io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientResponse<Req,Resp>> cached_0;
  public static <Req,Resp> GrpcClientRequest<Req,Resp> newInstance(io.vertx.grpc.client.GrpcClientRequest arg) {
    return arg != null ? new GrpcClientRequest<Req,Resp>(arg) : null;
  }

  public static <Req,Resp> GrpcClientRequest<Req,Resp> newInstance(io.vertx.grpc.client.GrpcClientRequest arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
    return arg != null ? new GrpcClientRequest<Req,Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
  }

}
