/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A builder for {@link io.vertx.reactivex.grpc.client.GrpcClient}.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClientBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClientBuilder.class)
public class GrpcClientBuilder<C> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClientBuilder that = (GrpcClientBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClientBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClientBuilder((io.vertx.grpc.client.GrpcClientBuilder) obj),
    GrpcClientBuilder::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClientBuilder<C> delegate;
  public final TypeArg<C> __typeArg_0;
  
  public GrpcClientBuilder(io.vertx.grpc.client.GrpcClientBuilder delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public GrpcClientBuilder(Object delegate, TypeArg<C> typeArg_0) {
    this.delegate = (io.vertx.grpc.client.GrpcClientBuilder)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.grpc.client.GrpcClientBuilder getDelegate() {
    return delegate;
  }


  /**
   * Configure the client options.
   * @param options the client options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> with(io.vertx.grpc.client.GrpcClientOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Configure the client HTTP transport options.
   * @param transportOptions the client transport options
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> with(io.vertx.core.http.HttpClientOptions transportOptions) { 
    delegate.with(transportOptions);
    return this;
  }

  /**
   * Build and return the client.
   * @return the client as configured by this builder
   */
  public C build() { 
    C ret = (C)__typeArg_0.wrap(delegate.build());
    return ret;
  }

  /**
   * Configure the client to use a specific address resolver.
   * @param resolver the address resolver
   * @return 
   */
  public io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> withAddressResolver(io.vertx.core.net.AddressResolver resolver) { 
    io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> ret = io.vertx.reactivex.grpc.client.GrpcClientBuilder.newInstance((io.vertx.grpc.client.GrpcClientBuilder)delegate.withAddressResolver(resolver), __typeArg_0);
    return ret;
  }

  /**
   * Configure the client to use a load balancer.
   * @param loadBalancer the load balancer
   * @return 
   */
  public io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> withLoadBalancer(io.vertx.core.net.endpoint.LoadBalancer loadBalancer) { 
    io.vertx.reactivex.grpc.client.GrpcClientBuilder<C> ret = io.vertx.reactivex.grpc.client.GrpcClientBuilder.newInstance((io.vertx.grpc.client.GrpcClientBuilder)delegate.withLoadBalancer(loadBalancer), __typeArg_0);
    return ret;
  }

  public static <C> GrpcClientBuilder<C> newInstance(io.vertx.grpc.client.GrpcClientBuilder arg) {
    return arg != null ? new GrpcClientBuilder<C>(arg) : null;
  }

  public static <C> GrpcClientBuilder<C> newInstance(io.vertx.grpc.client.GrpcClientBuilder arg, TypeArg<C> __typeArg_C) {
    return arg != null ? new GrpcClientBuilder<C>(arg, __typeArg_C) : null;
  }

}
