/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.grpc.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>A gRPC client for Vert.x</p>
 *
 * <p>Unlike traditional gRPC clients, this client does not rely on a generated RPC interface to interact with the service.</p>
 *
 * <p>Instead, you can interact with the service with a request/response interfaces and gRPC messages, very much like
 * a traditional client.</p>
 *
 * <p>The client handles only the gRPC protocol and does not encode/decode protobuf messages.</p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.client.GrpcClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.client.GrpcClient.class)
public class GrpcClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcClient that = (GrpcClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcClient> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcClient((io.vertx.grpc.client.GrpcClient) obj),
    GrpcClient::getDelegate
  );

  private final io.vertx.grpc.client.GrpcClient delegate;
  
  public GrpcClient(io.vertx.grpc.client.GrpcClient delegate) {
    this.delegate = delegate;
  }

  public GrpcClient(Object delegate) {
    this.delegate = (io.vertx.grpc.client.GrpcClient)delegate;
  }

  @Override 
  public io.vertx.grpc.client.GrpcClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.grpc.client.GrpcClient> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.grpc.client.GrpcClient>(o1 -> io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>>(o1 -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)o1, TypeArg.unknown(), TypeArg.unknown()), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>>(o1 -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)o1, TypeArg.unknown(), TypeArg.unknown()), o1 -> o1.getDelegate());

  /**
   * Provide a builder for {@link io.vertx.reactivex.grpc.client.GrpcClient}, it can be used to configure advanced
   * client settings like a load balancer or an address resolver.
   * <p>
   * Example usage: <code>GrpcClient client = GrpcClient.builder(vertx).with(options)...build()</code>
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.grpc.client.GrpcClientBuilder<io.vertx.reactivex.grpc.client.GrpcClient> builder(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.grpc.client.GrpcClientBuilder<io.vertx.reactivex.grpc.client.GrpcClient> ret = io.vertx.reactivex.grpc.client.GrpcClientBuilder.newInstance((io.vertx.grpc.client.GrpcClientBuilder)io.vertx.grpc.client.GrpcClient.builder(vertx.getDelegate()), TYPE_ARG_0);
    return ret;
  }

  /**
   * Create a client.
   * @param vertx the vertx instance
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a client.
   * @param vertx the vertx instance
   * @param options 
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.grpc.client.GrpcClientOptions options) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a client with the specified <code>options</code>.
   * @param vertx the vertx instance
   * @param grpcOptions the http client options
   * @param httpOptions the http client options
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.grpc.client.GrpcClientOptions grpcOptions, io.vertx.core.http.HttpClientOptions httpOptions) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), grpcOptions, httpOptions));
    return ret;
  }

  /**
   * Create a client with the specified <code>options</code>.
   * @param vertx the vertx instance
   * @param options the http client options
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.http.HttpClientOptions options) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a client wrapping an existing .
   * @param vertx the vertx instance
   * @param client the http client instance
   * @return the created client
   */
  public static io.vertx.reactivex.grpc.client.GrpcClient client(io.vertx.reactivex.core.Vertx vertx, io.vertx.reactivex.core.http.HttpClient client) { 
    io.vertx.reactivex.grpc.client.GrpcClient ret = io.vertx.reactivex.grpc.client.GrpcClient.newInstance((io.vertx.grpc.client.GrpcClient)io.vertx.grpc.client.GrpcClient.client(vertx.getDelegate(), client.getDelegate()));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> request(io.vertx.core.net.Address server) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> ret = delegate.request(server).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @return a future request
   */
  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> rxRequest(io.vertx.core.net.Address server) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request(server).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.grpc.client.GrpcClient#request} with the default remote server.
   * @return 
   */
  public io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> request() { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> ret = delegate.request().map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.grpc.client.GrpcClient#request} with the default remote server.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<io.vertx.core.buffer.Buffer,io.vertx.core.buffer.Buffer>> rxRequest() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.request().onComplete($handler);
    });
  }

  /**
   * Close this client.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close this client.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @param method the grpc method
   * @return a future request
   */
  public <Req, Resp> io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> request(io.vertx.core.net.Address server, io.vertx.grpc.common.ServiceMethod<Resp,Req> method) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> ret = delegate.request(server, method).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Connect to the remote <code>server</code> and create a request for any hosted gRPC service.
   * @param server the server hosting the service
   * @param method the grpc method
   * @return a future request
   */
  public <Req, Resp> io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> rxRequest(io.vertx.core.net.Address server, io.vertx.grpc.common.ServiceMethod<Resp,Req> method) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<Req, Resp>request(server, method).onComplete($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.grpc.client.GrpcClient#request} with the default remote server.
   * @param method 
   * @return 
   */
  public <Req, Resp> io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> request(io.vertx.grpc.common.ServiceMethod<Resp,Req> method) { 
    io.vertx.core.Future<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> ret = delegate.request(method).map(val -> io.vertx.reactivex.grpc.client.GrpcClientRequest.newInstance((io.vertx.grpc.client.GrpcClientRequest)val, TypeArg.unknown(), TypeArg.unknown()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.grpc.client.GrpcClient#request} with the default remote server.
   * @param method 
   * @return 
   */
  public <Req, Resp> io.reactivex.Single<io.vertx.reactivex.grpc.client.GrpcClientRequest<Req,Resp>> rxRequest(io.vertx.grpc.common.ServiceMethod<Resp,Req> method) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.<Req, Resp>request(method).onComplete($handler);
    });
  }

  public static GrpcClient newInstance(io.vertx.grpc.client.GrpcClient arg) {
    return arg != null ? new GrpcClient(arg) : null;
  }

}
