/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.validation.builder;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface is used to build parameter processors supported on every .
 * You can use in query and cookie more complex parameters with {@link io.vertx.reactivex.ext.web.validation.builder.StyledParameterProcessorFactory}. <br/>
 * <p>
 * Look at {@link io.vertx.reactivex.ext.web.validation.builder.Parameters} for all available factories
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.ParameterProcessorFactory original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.ParameterProcessorFactory.class)
public class ParameterProcessorFactory implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParameterProcessorFactory that = (ParameterProcessorFactory) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ParameterProcessorFactory> __TYPE_ARG = new TypeArg<>(    obj -> new ParameterProcessorFactory((io.vertx.ext.web.validation.builder.ParameterProcessorFactory) obj),
    ParameterProcessorFactory::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.ParameterProcessorFactory delegate;
  
  public ParameterProcessorFactory(io.vertx.ext.web.validation.builder.ParameterProcessorFactory delegate) {
    this.delegate = delegate;
  }

  public ParameterProcessorFactory(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.ParameterProcessorFactory)delegate;
  }

  @Override 
  public io.vertx.ext.web.validation.builder.ParameterProcessorFactory getDelegate() {
    return delegate;
  }

  public io.vertx.ext.web.validation.impl.parameter.ParameterProcessor create(io.vertx.ext.web.validation.impl.ParameterLocation location, io.vertx.reactivex.json.schema.SchemaRepository schemaRepo) { 
    io.vertx.ext.web.validation.impl.parameter.ParameterProcessor ret = delegate.create(location, schemaRepo.getDelegate());
    return ret;
  }

  public static ParameterProcessorFactory newInstance(io.vertx.ext.web.validation.builder.ParameterProcessorFactory arg) {
    return arg != null ? new ParameterProcessorFactory(arg) : null;
  }

}
