/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Container for request parameters
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.RequestParameters original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.RequestParameters.class)
public class RequestParameters implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequestParameters that = (RequestParameters) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RequestParameters> __TYPE_ARG = new TypeArg<>(    obj -> new RequestParameters((io.vertx.ext.web.validation.RequestParameters) obj),
    RequestParameters::getDelegate
  );

  private final io.vertx.ext.web.validation.RequestParameters delegate;
  
  public RequestParameters(io.vertx.ext.web.validation.RequestParameters delegate) {
    this.delegate = delegate;
  }

  public RequestParameters(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.RequestParameters)delegate;
  }

  @Override 
  public io.vertx.ext.web.validation.RequestParameters getDelegate() {
    return delegate;
  }


  /**
   * Get list of all parameter names inside path
   * @return 
   */
  public java.util.List<java.lang.String> pathParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.pathParametersNames();
    return ret;
  }

  /**
   * Get path parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.validation.RequestParameter pathParameter(java.lang.String name) { 
    io.vertx.reactivex.ext.web.validation.RequestParameter ret = io.vertx.reactivex.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)delegate.pathParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside query
   * @return 
   */
  public java.util.List<java.lang.String> queryParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.queryParametersNames();
    return ret;
  }

  /**
   * Get query parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.validation.RequestParameter queryParameter(java.lang.String name) { 
    io.vertx.reactivex.ext.web.validation.RequestParameter ret = io.vertx.reactivex.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)delegate.queryParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside header
   * @return 
   */
  public java.util.List<java.lang.String> headerParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.headerParametersNames();
    return ret;
  }

  /**
   * Get header parameter by name.
   * This getter is case insensitive.
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.validation.RequestParameter headerParameter(java.lang.String name) { 
    io.vertx.reactivex.ext.web.validation.RequestParameter ret = io.vertx.reactivex.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)delegate.headerParameter(name));
    return ret;
  }

  /**
   * Get list of all parameter names inside cookie
   * @return 
   */
  public java.util.List<java.lang.String> cookieParametersNames() { 
    java.util.List<java.lang.String> ret = delegate.cookieParametersNames();
    return ret;
  }

  /**
   * Get cookie parameter by name
   * @param name Parameter name
   * @return 
   */
  public io.vertx.reactivex.ext.web.validation.RequestParameter cookieParameter(java.lang.String name) { 
    io.vertx.reactivex.ext.web.validation.RequestParameter ret = io.vertx.reactivex.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)delegate.cookieParameter(name));
    return ret;
  }

  /**
   * Return request body when parsed. Forms are managed as 
   * @return 
   */
  public io.vertx.reactivex.ext.web.validation.RequestParameter body() { 
    io.vertx.reactivex.ext.web.validation.RequestParameter ret = io.vertx.reactivex.ext.web.validation.RequestParameter.newInstance((io.vertx.ext.web.validation.RequestParameter)delegate.body());
    return ret;
  }

  /**
   * This method converts RequestParameters in an unique JsonObject with 6 fields: cookie, path, query, header, form, body<br/>
   *
   * cookie, path, query, header, form are JsonObject where keys are param names and values are param values, while body depends on body's shape and may not exist
   * @return 
   */
  public io.vertx.core.json.JsonObject toJson() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    cached_0 = ret;
    return ret;
  }

  private io.vertx.core.json.JsonObject cached_0;
  public static RequestParameters newInstance(io.vertx.ext.web.validation.RequestParameters arg) {
    return arg != null ? new RequestParameters(arg) : null;
  }

}
