/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ.rocker;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the Rocker library.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.rocker.RockerTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.rocker.RockerTemplateEngine.class)
public class RockerTemplateEngine extends io.vertx.reactivex.ext.web.common.template.TemplateEngine implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RockerTemplateEngine that = (RockerTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RockerTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new RockerTemplateEngine((io.vertx.ext.web.templ.rocker.RockerTemplateEngine) obj),
    RockerTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.rocker.RockerTemplateEngine delegate;
  
  public RockerTemplateEngine(io.vertx.ext.web.templ.rocker.RockerTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public RockerTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.rocker.RockerTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.rocker.RockerTemplateEngine)delegate;
  }

  @Override 
  public io.vertx.ext.web.templ.rocker.RockerTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine create() { 
    io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine ret = io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine.newInstance((io.vertx.ext.web.templ.rocker.RockerTemplateEngine)io.vertx.ext.web.templ.rocker.RockerTemplateEngine.create());
    return ret;
  }

  /**
   * Create a template engine using a custom extension
   * @param extension 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine create(java.lang.String extension) { 
    io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine ret = io.vertx.reactivex.ext.web.templ.rocker.RockerTemplateEngine.newInstance((io.vertx.ext.web.templ.rocker.RockerTemplateEngine)io.vertx.ext.web.templ.rocker.RockerTemplateEngine.create(extension));
    return ret;
  }

  /**
   * Default template extension
   */
  public static final java.lang.String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.rocker.RockerTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static RockerTemplateEngine newInstance(io.vertx.ext.web.templ.rocker.RockerTemplateEngine arg) {
    return arg != null ? new RockerTemplateEngine(arg) : null;
  }

}
