/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ.pug;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses Pug.
 * The {@link io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine#unwrap} shall return an object of class 
 *
 * <p>Thís interface has been copied from <a href="https://github.com/vert-x3/vertx-web/blob/4.0.0/vertx-template-engines/vertx-web-templ-jade/src/main/java/io/vertx/ext/web/templ/jade/JadeTemplateEngine.java">
 * JadeTemplateEngine.java</a>.
 * Authors of JadeTemplateEngine.java are <a href="http://tfox.org">Tim Fox</a>, Paulo Lopes (pmlopes), Julien Viet (vietj),
 * Roman Novikov (mystdeim), nEJC (mrnejc), Yunyu Lin, Kevin Macksamie (k-mack), Geoffrey Clements (baldmountain).
 *
 * <p>For authors of this file see git history.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.pug.PugTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.pug.PugTemplateEngine.class)
public class PugTemplateEngine extends io.vertx.reactivex.ext.web.common.template.TemplateEngine implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PugTemplateEngine that = (PugTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PugTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new PugTemplateEngine((io.vertx.ext.web.templ.pug.PugTemplateEngine) obj),
    PugTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.pug.PugTemplateEngine delegate;
  
  public PugTemplateEngine(io.vertx.ext.web.templ.pug.PugTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PugTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.pug.PugTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.pug.PugTemplateEngine)delegate;
  }

  @Override 
  public io.vertx.ext.web.templ.pug.PugTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine ret = io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine.newInstance((io.vertx.ext.web.templ.pug.PugTemplateEngine)io.vertx.ext.web.templ.pug.PugTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @param extension 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine create(io.vertx.reactivex.core.Vertx vertx, java.lang.String extension) { 
    io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine ret = io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine.newInstance((io.vertx.ext.web.templ.pug.PugTemplateEngine)io.vertx.ext.web.templ.pug.PugTemplateEngine.create(vertx.getDelegate(), extension));
    return ret;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @param extension 
   * @param encoding 
   * @return the engine
   */
  public static io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine create(io.vertx.reactivex.core.Vertx vertx, java.lang.String extension, java.lang.String encoding) { 
    io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine ret = io.vertx.reactivex.ext.web.templ.pug.PugTemplateEngine.newInstance((io.vertx.ext.web.templ.pug.PugTemplateEngine)io.vertx.ext.web.templ.pug.PugTemplateEngine.create(vertx.getDelegate(), extension, encoding));
    return ret;
  }

  public de.neuland.pug4j.PugConfiguration unwrap() { 
    de.neuland.pug4j.PugConfiguration ret = delegate.unwrap();
    return ret;
  }

  /**
   * Default template extension
   */
  public static final java.lang.String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.pug.PugTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static PugTemplateEngine newInstance(io.vertx.ext.web.templ.pug.PugTemplateEngine arg) {
    return arg != null ? new PugTemplateEngine(arg) : null;
  }

}
