/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.sstore.infinispan;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An implementation of  that relies on the Infinispan Java Client.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore.class)
public class InfinispanSessionStore extends io.vertx.reactivex.ext.web.sstore.SessionStore implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InfinispanSessionStore that = (InfinispanSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<InfinispanSessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new InfinispanSessionStore((io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore) obj),
    InfinispanSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore delegate;
  
  public InfinispanSessionStore(io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public InfinispanSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore)delegate;
  }

  @Override 
  public io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore getDelegate() {
    return delegate;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore} for the given configuration.
   * @param vertx vertx instance
   * @param options the configuration
   * @return the new instance
   */
  public static io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore create(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject options) { 
    io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore ret = io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore.newInstance((io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore)io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore#create} but with a pre-configured Infinispan Client.
   * @param vertx vertx instance
   * @param options the configuration
   * @param remoteCacheManager pre-configured Infinispan Client
   * @return the new instance
   */
  public static io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore create(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject options, org.infinispan.client.hotrod.RemoteCacheManager remoteCacheManager) { 
    io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore ret = io.vertx.reactivex.ext.web.sstore.infinispan.InfinispanSessionStore.newInstance((io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore)io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore.create(vertx.getDelegate(), options, remoteCacheManager));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore.DEFAULT_SESSIONID_LENGTH;
  public static InfinispanSessionStore newInstance(io.vertx.ext.web.sstore.infinispan.InfinispanSessionStore arg) {
    return arg != null ? new InfinispanSessionStore(arg) : null;
  }

}
