/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.openapi.router;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An authentication handler factory. This class will hold factories for creating 
 * objects.
 * <p>
 * Handlers will be used when creating the router. This class will configure the handlers to some extent:
 *
 * <ul>
 *   <li> - api key handlers will be configured from the document to avoid setup mistakes</li>
 *   <li> - nothing is required to be configured, they will be used as is</li>
 *   <li> - nothing is required to be configured, they will be used as is</li>
 *   <li> - nothing is required to be configured, they will be used as is. Note that for scopes
 *   you may need to configure the provider to locate the claims in the right place</li>
 *   <li> can be used in two forms: <code>oauth2</code> or <code>openIdConnect</code>. When using
 *   <code>oauth2</code> the function will receive the openapi configuration and it is the function implementor
 *   responsibility to configure the handler correctly. For <code>openIdConnect</code> mode the asynchronous function can be
 *   used to use the discovery mechanism.</li>
 * </ul>
 *
 * And extra note on  callback. The callback is optional and if not provided the default
 * behavior is to validate tokens as bearer tokens. When specified the callback <b>must</b> be an absolute path relative
 * to the root of the router.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.router.Security original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.openapi.router.Security.class)
public class Security implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Security that = (Security) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Security> __TYPE_ARG = new TypeArg<>(    obj -> new Security((io.vertx.ext.web.openapi.router.Security) obj),
    Security::getDelegate
  );

  private final io.vertx.ext.web.openapi.router.Security delegate;
  
  public Security(io.vertx.ext.web.openapi.router.Security delegate) {
    this.delegate = delegate;
  }

  public Security(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.router.Security)delegate;
  }

  @Override 
  public io.vertx.ext.web.openapi.router.Security getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder>(o1 -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder>(o1 -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)o1), o1 -> o1.getDelegate());

  /**
   * Configure the  to be used when creating the router.
   * @param handler the handler to be used
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder apiKeyHandler(io.vertx.reactivex.ext.web.handler.APIKeyHandler handler) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.apiKeyHandler(handler.getDelegate()));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param handler the handler to be used
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder httpHandler(io.vertx.reactivex.ext.web.handler.BasicAuthHandler handler) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.httpHandler(handler.getDelegate()));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param handler the handler to be used
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder httpHandler(io.vertx.reactivex.ext.web.handler.DigestAuthHandler handler) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.httpHandler(handler.getDelegate()));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param handler the handler to be used
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder httpHandler(io.vertx.reactivex.ext.web.handler.JWTAuthHandler handler) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.httpHandler(handler.getDelegate()));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param callback the callback path to be used to validate tokens
   * @param factory the handler factory that will receive the configuration and return the handler
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder oauth2Handler(java.lang.String callback, java.util.function.Function<io.vertx.reactivex.openapi.contract.SecurityScheme,io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> factory) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.oauth2Handler(callback, new Function<io.vertx.openapi.contract.SecurityScheme,io.vertx.ext.web.handler.OAuth2AuthHandler>() {
      public io.vertx.ext.web.handler.OAuth2AuthHandler apply(io.vertx.openapi.contract.SecurityScheme arg) {
        io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler ret = factory.apply(io.vertx.reactivex.openapi.contract.SecurityScheme.newInstance((io.vertx.openapi.contract.SecurityScheme)arg));
        return ret.getDelegate();
      }
    }));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router. In this mode the callback is not used
   * and will not handle <code>authorization_code</code> flows.
   * @param factory the handler factory that will receive the configuration and return the handler
   * @return caller builder
   */
  public io.vertx.reactivex.ext.web.openapi.router.RouterBuilder oauth2Handler(java.util.function.Function<io.vertx.reactivex.openapi.contract.SecurityScheme,io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> factory) { 
    io.vertx.reactivex.ext.web.openapi.router.RouterBuilder ret = io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)delegate.oauth2Handler(new Function<io.vertx.openapi.contract.SecurityScheme,io.vertx.ext.web.handler.OAuth2AuthHandler>() {
      public io.vertx.ext.web.handler.OAuth2AuthHandler apply(io.vertx.openapi.contract.SecurityScheme arg) {
        io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler ret = factory.apply(io.vertx.reactivex.openapi.contract.SecurityScheme.newInstance((io.vertx.openapi.contract.SecurityScheme)arg));
        return ret.getDelegate();
      }
    }));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param callback the callback path to be used to validate tokens
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> openIdConnectHandler(java.lang.String callback, java.util.function.Function<java.lang.String,io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> ret = delegate.openIdConnectHandler(callback, new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler>>() {
      public io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler> apply(java.lang.String arg) {
        io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> ret = factory.apply(arg);
        return ret.map(val -> val.getDelegate());
      }
    }).map(val -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)val));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param callback the callback path to be used to validate tokens
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> rxOpenIdConnectHandler(java.lang.String callback, java.util.function.Function<java.lang.String,io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.openIdConnectHandler(callback, factory).onComplete($handler);
    });
  }

  /**
   * Configure the  to be used when creating the router.
   * @param callback the callback path to be used to validate tokens
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> openIdConnectHandler(java.lang.String callback, io.reactivex.functions.Function<java.lang.String,io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> ret = delegate.openIdConnectHandler(callback, new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler>>() {
      public io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler> apply(java.lang.String arg) {
        io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> ret;
        try {
          ret = factory.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    }).map(val -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)val));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router.
   * @param callback the callback path to be used to validate tokens
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> rxOpenIdConnectHandler(java.lang.String callback, io.reactivex.functions.Function<java.lang.String,io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.openIdConnectHandler(callback, factory).onComplete($handler);
    });
  }

  /**
   * Configure the  to be used when creating the router. In this mode the callback is not used
   * and will not handle <code>authorization_code</code> flows.
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> openIdConnectHandler(java.util.function.Function<java.lang.String,io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> ret = delegate.openIdConnectHandler(new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler>>() {
      public io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler> apply(java.lang.String arg) {
        io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> ret = factory.apply(arg);
        return ret.map(val -> val.getDelegate());
      }
    }).map(val -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)val));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router. In this mode the callback is not used
   * and will not handle <code>authorization_code</code> flows.
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> rxOpenIdConnectHandler(java.util.function.Function<java.lang.String,io.vertx.core.Future<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.openIdConnectHandler(factory).onComplete($handler);
    });
  }

  /**
   * Configure the  to be used when creating the router. In this mode the callback is not used
   * and will not handle <code>authorization_code</code> flows.
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> openIdConnectHandler(io.reactivex.functions.Function<java.lang.String,io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> ret = delegate.openIdConnectHandler(new Function<java.lang.String,io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler>>() {
      public io.vertx.core.Future<io.vertx.ext.web.handler.OAuth2AuthHandler> apply(java.lang.String arg) {
        io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler> ret;
        try {
          ret = factory.apply(arg);
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    }).map(val -> io.vertx.reactivex.ext.web.openapi.router.RouterBuilder.newInstance((io.vertx.ext.web.openapi.router.RouterBuilder)val));
    return ret;
  }

  /**
   * Configure the  to be used when creating the router. In this mode the callback is not used
   * and will not handle <code>authorization_code</code> flows.
   * @param factory the handler factory that will receive the <code>openIdConnect</code> discovery url and return the handler
   * @return caller builder
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.web.openapi.router.RouterBuilder> rxOpenIdConnectHandler(io.reactivex.functions.Function<java.lang.String,io.reactivex.Single<io.vertx.reactivex.ext.web.handler.OAuth2AuthHandler>> factory) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.openIdConnectHandler(factory).onComplete($handler);
    });
  }

  public static Security newInstance(io.vertx.ext.web.openapi.router.Security arg) {
    return arg != null ? new Security(arg) : null;
  }

}
