/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.multipart;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A form data part of a {@link io.vertx.reactivex.ext.web.multipart.MultipartForm}.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.multipart.FormDataPart original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.multipart.FormDataPart.class)
public class FormDataPart implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FormDataPart that = (FormDataPart) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FormDataPart> __TYPE_ARG = new TypeArg<>(    obj -> new FormDataPart((io.vertx.ext.web.multipart.FormDataPart) obj),
    FormDataPart::getDelegate
  );

  private final io.vertx.ext.web.multipart.FormDataPart delegate;
  
  public FormDataPart(io.vertx.ext.web.multipart.FormDataPart delegate) {
    this.delegate = delegate;
  }

  public FormDataPart(Object delegate) {
    this.delegate = (io.vertx.ext.web.multipart.FormDataPart)delegate;
  }

  @Override 
  public io.vertx.ext.web.multipart.FormDataPart getDelegate() {
    return delegate;
  }

  /**
   * @return the name
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> when this part is an attribute
   */
  public boolean isAttribute() { 
    if (cached_1 != null) {
      return cached_1;
    }
    boolean ret = delegate.isAttribute();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> when this part is a file upload
   */
  public boolean isFileUpload() { 
    if (cached_2 != null) {
      return cached_2;
    }
    boolean ret = delegate.isFileUpload();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the value when the part for a form attribute otherwise <code>null</code>
   */
  public java.lang.String value() { 
    if (cached_3 != null) {
      return cached_3;
    }
    java.lang.String ret = delegate.value();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the filename when this part is a file upload otherwise <code>null</code>
   */
  public java.lang.String filename() { 
    if (cached_4 != null) {
      return cached_4;
    }
    java.lang.String ret = delegate.filename();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the pathname when this part is a file upload created with a pathname otherwise <code>null</code>
   */
  public java.lang.String pathname() { 
    if (cached_5 != null) {
      return cached_5;
    }
    java.lang.String ret = delegate.pathname();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the content when this part is a file upload created with a buffer otherwise <code>null</code>
   */
  public io.vertx.core.buffer.Buffer content() { 
    if (cached_6 != null) {
      return cached_6;
    }
    io.vertx.core.buffer.Buffer ret = delegate.content();
    cached_6 = ret;
    return ret;
  }

  /**
   * @return the media type when this part is a file upload otherwise <code>null</code>
   */
  public java.lang.String mediaType() { 
    if (cached_7 != null) {
      return cached_7;
    }
    java.lang.String ret = delegate.mediaType();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return whether the file upload is text or binary when this part is a file upload otherwise <code>null</code>
   */
  public java.lang.Boolean isText() { 
    if (cached_8 != null) {
      return cached_8;
    }
    java.lang.Boolean ret = delegate.isText();
    cached_8 = ret;
    return ret;
  }

  private java.lang.String cached_0;
  private java.lang.Boolean cached_1;
  private java.lang.Boolean cached_2;
  private java.lang.String cached_3;
  private java.lang.String cached_4;
  private java.lang.String cached_5;
  private io.vertx.core.buffer.Buffer cached_6;
  private java.lang.String cached_7;
  private java.lang.Boolean cached_8;
  public static FormDataPart newInstance(io.vertx.ext.web.multipart.FormDataPart arg) {
    return arg != null ? new FormDataPart(arg) : null;
  }

}
