/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.sockjs;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * You interact with SockJS clients through instances of SockJS socket.
 * <p>
 * The API is very similar to {@link io.vertx.reactivex.core.http.WebSocket}.
 * It implements both  and 
 * so it can be used with
 *  to pump data with flow control.<p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.sockjs.SockJSSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.sockjs.SockJSSocket.class)
public class SockJSSocket implements RxDelegate, io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer>, io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SockJSSocket that = (SockJSSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SockJSSocket> __TYPE_ARG = new TypeArg<>(    obj -> new SockJSSocket((io.vertx.ext.web.handler.sockjs.SockJSSocket) obj),
    SockJSSocket::getDelegate
  );

  private final io.vertx.ext.web.handler.sockjs.SockJSSocket delegate;
  
  public SockJSSocket(io.vertx.ext.web.handler.sockjs.SockJSSocket delegate) {
    this.delegate = delegate;
  }

  public SockJSSocket(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.sockjs.SockJSSocket getDelegate() {
    return delegate;
  }

  private io.reactivex.Observable<io.vertx.core.buffer.Buffer> observable;
  private io.reactivex.Flowable<io.vertx.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.Observable<io.vertx.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      observable = ObservableHelper.toObservable(this.getDelegate());
    }
    return observable;
  }

  public synchronized io.reactivex.Flowable<io.vertx.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      flowable = FlowableHelper.toFlowable(this.getDelegate());
    }
    return flowable;
  }

  private WriteStreamObserver<io.vertx.core.buffer.Buffer> observer;
  private WriteStreamSubscriber<io.vertx.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamObserver<io.vertx.core.buffer.Buffer> toObserver() {
    if (observer == null) {
      observer = RxHelper.toObserver(getDelegate());
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<io.vertx.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      subscriber = RxHelper.toSubscriber(getDelegate());
    }
    return subscriber;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> pipe() { 
    io.vertx.reactivex.core.streams.Pipe<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.vertx.core.Future<java.lang.Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.pipeTo(dst.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * @param dst the destination write stream
   * @return a future notified when the write stream will be ended with the outcome
   */
  public io.reactivex.Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.pipeTo(dst).onComplete($handler);
    });
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.vertx.core.Future<java.lang.Void> end(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end(data).map(val -> val);
    return ret;
  }

  /**
   * Same as {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   * @return a future completed with the result
   */
  public io.reactivex.Completable rxEnd(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end(data).onComplete($handler);
    });
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket handler(io.vertx.core.Handler<io.vertx.core.buffer.Buffer> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket closeHandler(io.vertx.core.Handler<java.lang.Void> closeHandler) { 
    io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket ret = io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket.newInstance((io.vertx.ext.web.handler.sockjs.SockJSSocket)delegate.closeHandler(closeHandler));
    return ret;
  }

  public io.vertx.core.Future<java.lang.Void> write(io.vertx.core.buffer.Buffer data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data).map(val -> val);
    return ret;
  }

  public io.reactivex.Completable rxWrite(io.vertx.core.buffer.Buffer data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  /**
   * Write a {@link java.lang.String} to the socket, encoded in UTF-8.
   * @param data the string to write
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> write(java.lang.String data) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.write(data).map(val -> val);
    return ret;
  }

  /**
   * Write a {@link java.lang.String} to the socket, encoded in UTF-8.
   * @param data the string to write
   * @return 
   */
  public io.reactivex.Completable rxWrite(java.lang.String data) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.write(data).onComplete($handler);
    });
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>SockJSSocket</code> is created it can register an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying socket. This
   * allows you to write data to other sockets which are owned by different event loops.
   * @return the <code>writeHandlerID</code> or <code>null</code> if <code>writeHandler</code> registration is disabled in {@link io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions}
   */
  public java.lang.String writeHandlerID() { 
    java.lang.String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Call {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#close}.
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> end() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.end().map(val -> val);
    return ret;
  }

  /**
   * Call {@link io.vertx.reactivex.ext.web.handler.sockjs.SockJSSocket#close}.
   * @return 
   */
  public io.reactivex.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.end().onComplete($handler);
    });
  }

  /**
   * Close it
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close it giving a status code and reason. Only Applicable to RawWebSocket will downgrade to plain close for
   * other transports.
   * @param statusCode 
   * @param reason 
   */
  public void close(int statusCode, java.lang.String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Return the remote address for this socket
   * @return 
   */
  public io.vertx.core.net.SocketAddress remoteAddress() { 
    io.vertx.core.net.SocketAddress ret = delegate.remoteAddress();
    return ret;
  }

  /**
   * Return the local address for this socket
   * @return 
   */
  public io.vertx.core.net.SocketAddress localAddress() { 
    io.vertx.core.net.SocketAddress ret = delegate.localAddress();
    return ret;
  }

  /**
   * Return the headers corresponding to the last request for this socket or the websocket handshake
   * Any cookie headers will be removed for security reasons
   * @return 
   */
  public io.vertx.core.MultiMap headers() { 
    io.vertx.core.MultiMap ret = delegate.headers();
    return ret;
  }

  /**
   * Return the URI corresponding to the last request for this socket or the websocket handshake
   * @return 
   */
  public java.lang.String uri() { 
    java.lang.String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the Vert.x-Web RoutingContext corresponding to this socket
   */
  public io.vertx.reactivex.ext.web.RoutingContext routingContext() { 
    io.vertx.reactivex.ext.web.RoutingContext ret = io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)delegate.routingContext());
    return ret;
  }

  /**
   * @return the Vert.x-Web session corresponding to this socket
   */
  public io.vertx.reactivex.ext.web.Session webSession() { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.webSession());
    return ret;
  }

  /**
   * @return the Vert.x-Web user corresponding to this socket
   */
  public io.vertx.reactivex.ext.auth.User webUser() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.webUser());
    return ret;
  }

  public static SockJSSocket newInstance(io.vertx.ext.web.handler.sockjs.SockJSSocket arg) {
    return arg != null ? new SockJSSocket(arg) : null;
  }

}
