/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.handler.graphql.UploadScalar.class)
public class UploadScalar implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UploadScalar that = (UploadScalar) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UploadScalar> __TYPE_ARG = new TypeArg<>(    obj -> new UploadScalar((io.vertx.ext.web.handler.graphql.UploadScalar) obj),
    UploadScalar::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.UploadScalar delegate;
  
  public UploadScalar(io.vertx.ext.web.handler.graphql.UploadScalar delegate) {
    this.delegate = delegate;
  }

  public UploadScalar(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.UploadScalar)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.UploadScalar getDelegate() {
    return delegate;
  }

  public static graphql.schema.GraphQLScalarType build() { 
    graphql.schema.GraphQLScalarType ret = io.vertx.ext.web.handler.graphql.UploadScalar.build();
    return ret;
  }

  public static UploadScalar newInstance(io.vertx.ext.web.handler.graphql.UploadScalar arg) {
    return arg != null ? new UploadScalar(arg) : null;
  }

}
