/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler for GraphiQL resources.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphiQLHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.GraphiQLHandler.class)
public class GraphiQLHandler implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphiQLHandler that = (GraphiQLHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphiQLHandler> __TYPE_ARG = new TypeArg<>(    obj -> new GraphiQLHandler((io.vertx.ext.web.handler.graphql.GraphiQLHandler) obj),
    GraphiQLHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate;
  
  public GraphiQLHandler(io.vertx.ext.web.handler.graphql.GraphiQLHandler delegate) {
    this.delegate = delegate;
  }

  public GraphiQLHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.GraphiQLHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.GraphiQLHandler getDelegate() {
    return delegate;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}.
   * <p>
   * The handler will be configured with the given <code>options</code>.
   * @param vertx 
   * @param options options for configuring the {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler}
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions options) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandler)io.vertx.ext.web.handler.graphql.GraphiQLHandler.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a new {@link io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandlerBuilder} with default {@link io.vertx.ext.web.handler.graphql.GraphiQLHandlerOptions}.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandlerBuilder builder(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandlerBuilder ret = io.vertx.reactivex.ext.web.handler.graphql.GraphiQLHandlerBuilder.newInstance((io.vertx.ext.web.handler.graphql.GraphiQLHandlerBuilder)io.vertx.ext.web.handler.graphql.GraphiQLHandler.builder(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates a router configured to serve GraphiQL resources.
   * @return a router to be mounted on an existing {@link io.vertx.reactivex.ext.web.Route}
   */
  public io.vertx.reactivex.ext.web.Router router() { 
    io.vertx.reactivex.ext.web.Router ret = io.vertx.reactivex.ext.web.Router.newInstance((io.vertx.ext.web.Router)delegate.router());
    return ret;
  }

  public static GraphiQLHandler newInstance(io.vertx.ext.web.handler.graphql.GraphiQLHandler arg) {
    return arg != null ? new GraphiQLHandler(arg) : null;
  }

}
