/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A builder for {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler} instances.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder.class)
public class GraphQLHandlerBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GraphQLHandlerBuilder that = (GraphQLHandlerBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GraphQLHandlerBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new GraphQLHandlerBuilder((io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder) obj),
    GraphQLHandlerBuilder::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder delegate;
  
  public GraphQLHandlerBuilder(io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder delegate) {
    this.delegate = delegate;
  }

  public GraphQLHandlerBuilder(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder getDelegate() {
    return delegate;
  }

  /**
   * Change the {@link io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions} to use.
   * @param options 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandlerBuilder with(io.vertx.ext.web.handler.graphql.GraphQLHandlerOptions options) { 
    delegate.with(options);
    return this;
  }

  /**
   * Set a callback to invoke before executing a GraphQL query.
   * @param beforeExecuteHandler the callback to invoke
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandlerBuilder beforeExecute(io.vertx.core.Handler<io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext<io.vertx.reactivex.ext.web.RoutingContext>> beforeExecuteHandler) { 
    delegate.beforeExecute(io.vertx.lang.reactivex.Helper.convertHandler(beforeExecuteHandler, event -> io.vertx.reactivex.ext.web.handler.graphql.ExecutionInputBuilderWithContext.newInstance((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)event, new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o0 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o0), o0 -> o0.getDelegate()))));
    return this;
  }

  /**
   * @return a new instance of {@link io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler}
   */
  public io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler build() { 
    io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler ret = io.vertx.reactivex.ext.web.handler.graphql.GraphQLHandler.newInstance((io.vertx.ext.web.handler.graphql.GraphQLHandler)delegate.build());
    return ret;
  }

  public static GraphQLHandlerBuilder newInstance(io.vertx.ext.web.handler.graphql.GraphQLHandlerBuilder arg) {
    return arg != null ? new GraphQLHandlerBuilder(arg) : null;
  }

}
