/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler.graphql;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Holds a  with a contextual object.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext.class)
public class ExecutionInputBuilderWithContext<C> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ExecutionInputBuilderWithContext that = (ExecutionInputBuilderWithContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ExecutionInputBuilderWithContext> __TYPE_ARG = new TypeArg<>(    obj -> new ExecutionInputBuilderWithContext((io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext) obj),
    ExecutionInputBuilderWithContext::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext<C> delegate;
  public final TypeArg<C> __typeArg_0;
  
  public ExecutionInputBuilderWithContext(io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public ExecutionInputBuilderWithContext(Object delegate, TypeArg<C> typeArg_0) {
    this.delegate = (io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext getDelegate() {
    return delegate;
  }

  /**
   * @return the contextual object
   */
  public C context() { 
    C ret = (C)__typeArg_0.wrap(delegate.context());
    return ret;
  }

  /**
   * @return the GraphQL execution input builder
   */
  public graphql.ExecutionInput.Builder builder() { 
    graphql.ExecutionInput.Builder ret = delegate.builder();
    return ret;
  }

  public static <C> ExecutionInputBuilderWithContext<C> newInstance(io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext arg) {
    return arg != null ? new ExecutionInputBuilderWithContext<C>(arg) : null;
  }

  public static <C> ExecutionInputBuilderWithContext<C> newInstance(io.vertx.ext.web.handler.graphql.ExecutionInputBuilderWithContext arg, TypeArg<C> __typeArg_C) {
    return arg != null ? new ExecutionInputBuilderWithContext<C>(arg, __typeArg_C) : null;
  }

}
