/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides FIDO2 WebAuthN Relay Party support.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.WebAuthn4JHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.WebAuthn4JHandler.class)
public class WebAuthn4JHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.AuthenticationHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthn4JHandler that = (WebAuthn4JHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebAuthn4JHandler> __TYPE_ARG = new TypeArg<>(    obj -> new WebAuthn4JHandler((io.vertx.ext.web.handler.WebAuthn4JHandler) obj),
    WebAuthn4JHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.WebAuthn4JHandler delegate;
  
  public WebAuthn4JHandler(io.vertx.ext.web.handler.WebAuthn4JHandler delegate) {
    this.delegate = delegate;
  }

  public WebAuthn4JHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.WebAuthn4JHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.WebAuthn4JHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a WebAuthN auth handler. This handler expects at least the response callback to be installed.
   * @param webAuthn 
   * @return the auth handler
   */
  public static io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler create(io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J webAuthn) { 
    io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler ret = io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler.newInstance((io.vertx.ext.web.handler.WebAuthn4JHandler)io.vertx.ext.web.handler.WebAuthn4JHandler.create(webAuthn.getDelegate()));
    return ret;
  }

  /**
   * The callback route to create registration attestations. Usually this route is <pre>/webauthn/register</pre>
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler setupCredentialsCreateCallback(io.vertx.reactivex.ext.web.Route route) { 
    delegate.setupCredentialsCreateCallback(route.getDelegate());
    return this;
  }

  /**
   * The callback route to create login attestations. Usually this route is <pre>/webauthn/login</pre>
   * @param route the route where credential get options are generated.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler setupCredentialsGetCallback(io.vertx.reactivex.ext.web.Route route) { 
    delegate.setupCredentialsGetCallback(route.getDelegate());
    return this;
  }

  /**
   * The callback route to verify attestations and assertions. Usually this route is <pre>/webauthn/response</pre>
   * @param route the route where assertions and attestations are verified.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler setupCallback(io.vertx.reactivex.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  /**
   * Set the Origin to be validated by the webauthn object.
   * @param origin - an HTTP Origin
   * @return fluent self
   */
  public io.vertx.reactivex.ext.web.handler.WebAuthn4JHandler setOrigin(java.lang.String origin) { 
    delegate.setOrigin(origin);
    return this;
  }

  public static WebAuthn4JHandler newInstance(io.vertx.ext.web.handler.WebAuthn4JHandler arg) {
    return arg != null ? new WebAuthn4JHandler(arg) : null;
  }

}
