/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler that logs security audit events. This handler is to be used with the underlying logger
 * <code>io.vertx.ext.auth.audit</code>.
 *
 * This handler will ensure that logs are structured and that sensitive data is masked. This information can be used to
 * feed SIEM or EDR/XDR tools to monitor and detect security incidents.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.SecurityAuditLoggerHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.SecurityAuditLoggerHandler.class)
public class SecurityAuditLoggerHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.PlatformHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityAuditLoggerHandler that = (SecurityAuditLoggerHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SecurityAuditLoggerHandler> __TYPE_ARG = new TypeArg<>(    obj -> new SecurityAuditLoggerHandler((io.vertx.ext.web.handler.SecurityAuditLoggerHandler) obj),
    SecurityAuditLoggerHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.SecurityAuditLoggerHandler delegate;
  
  public SecurityAuditLoggerHandler(io.vertx.ext.web.handler.SecurityAuditLoggerHandler delegate) {
    this.delegate = delegate;
  }

  public SecurityAuditLoggerHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.SecurityAuditLoggerHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.SecurityAuditLoggerHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a new instance of the handler. For each request the audit data is collected and will be logged explicitly
   * by {@link io.vertx.reactivex.ext.web.handler.AuthorizationHandler} and {@link io.vertx.reactivex.ext.web.handler.AuthorizationHandler} instances. The handler will also log the final
   * status of the current request. The marker kinds are defined in the enum {@link io.vertx.ext.auth.audit.Marker}.
   * @return 
   */
  public static io.vertx.reactivex.ext.web.handler.SecurityAuditLoggerHandler create() { 
    io.vertx.reactivex.ext.web.handler.SecurityAuditLoggerHandler ret = io.vertx.reactivex.ext.web.handler.SecurityAuditLoggerHandler.newInstance((io.vertx.ext.web.handler.SecurityAuditLoggerHandler)io.vertx.ext.web.handler.SecurityAuditLoggerHandler.create());
    return ret;
  }

  public static SecurityAuditLoggerHandler newInstance(io.vertx.ext.web.handler.SecurityAuditLoggerHandler arg) {
    return arg != null ? new SecurityAuditLoggerHandler(arg) : null;
  }

}
