/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Handler which adds a header `x-response-time` in the response of matching requests containing the time taken
 * in ms to process the request.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ResponseTimeHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.ResponseTimeHandler.class)
public class ResponseTimeHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.PlatformHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponseTimeHandler that = (ResponseTimeHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ResponseTimeHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ResponseTimeHandler((io.vertx.ext.web.handler.ResponseTimeHandler) obj),
    ResponseTimeHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ResponseTimeHandler delegate;
  
  public ResponseTimeHandler(io.vertx.ext.web.handler.ResponseTimeHandler delegate) {
    this.delegate = delegate;
  }

  public ResponseTimeHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ResponseTimeHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.ResponseTimeHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.ResponseTimeHandler create() { 
    io.vertx.reactivex.ext.web.handler.ResponseTimeHandler ret = io.vertx.reactivex.ext.web.handler.ResponseTimeHandler.newInstance((io.vertx.ext.web.handler.ResponseTimeHandler)io.vertx.ext.web.handler.ResponseTimeHandler.create());
    return ret;
  }

  public static ResponseTimeHandler newInstance(io.vertx.ext.web.handler.ResponseTimeHandler arg) {
    return arg != null ? new ResponseTimeHandler(arg) : null;
  }

}
