/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base interface for handlers that perform protocol upgrades.
 *
 * Sub-interfaces hint vert.x core that we should hold the request. This allows later parsing. It can be available
 * during the upgrade, even if there are asynchronous calls in between.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ProtocolUpgradeHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.ProtocolUpgradeHandler.class)
public interface ProtocolUpgradeHandler extends RxDelegate, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override 
  io.vertx.ext.web.handler.ProtocolUpgradeHandler getDelegate();

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event);

  public static ProtocolUpgradeHandler newInstance(io.vertx.ext.web.handler.ProtocolUpgradeHandler arg) {
    return arg != null ? new ProtocolUpgradeHandlerImpl(arg) : null;
  }

}

class ProtocolUpgradeHandlerImpl implements ProtocolUpgradeHandler {
  private final io.vertx.ext.web.handler.ProtocolUpgradeHandler delegate;
  
  public ProtocolUpgradeHandlerImpl(io.vertx.ext.web.handler.ProtocolUpgradeHandler delegate) {
    this.delegate = delegate;
  }

  public ProtocolUpgradeHandlerImpl(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ProtocolUpgradeHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.ProtocolUpgradeHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

}
