/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * HTTP Strict Transport Security (HSTS) <a href="http://tools.ietf.org/html/rfc6797">RFC6797</a>.
 *
 * This handler adds the strict transport security headers, for this domain or subdomains.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.HSTSHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.HSTSHandler.class)
public class HSTSHandler implements RxDelegate, io.vertx.reactivex.ext.web.handler.SecurityPolicyHandler, Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HSTSHandler that = (HSTSHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HSTSHandler> __TYPE_ARG = new TypeArg<>(    obj -> new HSTSHandler((io.vertx.ext.web.handler.HSTSHandler) obj),
    HSTSHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.HSTSHandler delegate;
  
  public HSTSHandler(io.vertx.ext.web.handler.HSTSHandler delegate) {
    this.delegate = delegate;
  }

  public HSTSHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.HSTSHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.HSTSHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Creates a new instance that shall consider the configuration for sub domains.
   * @param maxAge max age to attribute to the header
   * @param includeSubDomains consider sub domains when adding the header
   * @return an instance.
   */
  public static io.vertx.reactivex.ext.web.handler.HSTSHandler create(long maxAge, boolean includeSubDomains) { 
    io.vertx.reactivex.ext.web.handler.HSTSHandler ret = io.vertx.reactivex.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create(maxAge, includeSubDomains));
    return ret;
  }

  /**
   * Creates a new instance that shall consider the configuration for sub domains.
   * @param includeSubDomains consider sub domains when adding the header
   * @return an instance.
   */
  public static io.vertx.reactivex.ext.web.handler.HSTSHandler create(boolean includeSubDomains) { 
    io.vertx.reactivex.ext.web.handler.HSTSHandler ret = io.vertx.reactivex.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create(includeSubDomains));
    return ret;
  }

  /**
   * Creates a new instance that does not consider the configuration for sub domains.
   * Using the default max age.
   * @return an instance.
   */
  public static io.vertx.reactivex.ext.web.handler.HSTSHandler create() { 
    io.vertx.reactivex.ext.web.handler.HSTSHandler ret = io.vertx.reactivex.ext.web.handler.HSTSHandler.newInstance((io.vertx.ext.web.handler.HSTSHandler)io.vertx.ext.web.handler.HSTSHandler.create());
    return ret;
  }

  public static final long DEFAULT_MAX_AGE = io.vertx.ext.web.handler.HSTSHandler.DEFAULT_MAX_AGE;
  public static HSTSHandler newInstance(io.vertx.ext.web.handler.HSTSHandler arg) {
    return arg != null ? new HSTSHandler(arg) : null;
  }

}
