/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous HTTP / HTTP/2 client called <code>WebClient</code>.
 * <p>
 * The web client makes easy to do HTTP request/response interactions with a web server, and provides advanced
 * features like:
 * <ul>
 *   <li>Json body encoding / decoding</li>
 *   <li>request/response pumping</li>
 *   <li>error handling</li>
 * </ul>
 * <p>
 * The web client does not deprecate the , it is actually based on it and therefore inherits
 * its configuration and great features like pooling. The <code>HttpClient</code> should be used when fine grained control over the HTTP
 * requests/response is necessary.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.WebClient.class)
public class WebClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClient that = (WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebClient> __TYPE_ARG = new TypeArg<>(    obj -> new WebClient((io.vertx.ext.web.client.WebClient) obj),
    WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.WebClient delegate;
  
  public WebClient(io.vertx.ext.web.client.WebClient delegate) {
    this.delegate = delegate;
  }

  public WebClient(Object delegate) {
    this.delegate = (io.vertx.ext.web.client.WebClient)delegate;
  }

  @Override 
  public io.vertx.ext.web.client.WebClient getDelegate() {
    return delegate;
  }


  /**
   * Create a web client using the provided <code>vertx</code> instance and default options.
   * @param vertx the vertx instance
   * @return the created web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a web client using the provided <code>vertx</code> instance and default pooling options.
   * @param vertx the vertx instance
   * @param options the Web Client options
   * @return the created web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.web.client.WebClientOptions options) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a web client using the provided <code>vertx</code> instance.
   * @param vertx the vertx instance
   * @param options the Web Client options
   * @param poolOptions the HTTP Client pool options
   * @return the created web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.web.client.WebClientOptions options, io.vertx.core.http.PoolOptions poolOptions) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.create(vertx.getDelegate(), options, poolOptions));
    return ret;
  }

  /**
   * Wrap an <code>httpClient</code> with a web client and default options.
   * @param httpClient the  to wrap
   * @return the web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient wrap(io.vertx.reactivex.core.http.HttpClient httpClient) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate()));
    return ret;
  }

  /**
   * Wrap an <code>httpClient</code> with a web client and default options.
   * <p>
   * Only the specific web client portion of the <code>options</code> is used, the {@link io.vertx.core.http.HttpClientOptions}
   * of the <code>httpClient</code> is reused.
   * @param httpClient the  to wrap
   * @param options the Web Client options
   * @return the web client
   */
  public static io.vertx.reactivex.ext.web.client.WebClient wrap(io.vertx.reactivex.core.http.HttpClient httpClient, io.vertx.ext.web.client.WebClientOptions options) { 
    io.vertx.reactivex.ext.web.client.WebClient ret = io.vertx.reactivex.ext.web.client.WebClient.newInstance((io.vertx.ext.web.client.WebClient)io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate(), options));
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and port.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and port.
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>port</code> and <code>host</code> parameters.
   * <p>
   * The request host header will still be created from the <code>port</code> and <code>host</code> parameters.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>port</code> and <code>host</code> parameters.
   * <p>
   * The request host header will still be created from the <code>port</code> and <code>host</code> parameters.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and default port.
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and <code>host</code> parameter.
   * <p>
   * The request host header will still be created from the default port and <code>host</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and <code>host</code> parameter.
   * <p>
   * The request host header will still be created from the default port and <code>host</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the default host and port.
   * @param method the HTTP method
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and default host.
   * <p>
   * The request host header will still be created from the default port and default host.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the default port and default host.
   * <p>
   * The request host header will still be created from the default port and default host.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server at the specified host and port.
   * @param method the HTTP method
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.http.RequestOptions options) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#request} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>options</code> parameter.
   * <p>
   * The request host header will still be created from the <code>options</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> request(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, io.vertx.core.http.RequestOptions options) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.request(method, serverAddress, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server using an absolute URI
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP request to send to the server using an absolute URI
   * @param method the HTTP method
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#requestAbs} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>absoluteURI</code> parameter.
   * <p>
   * The request host header will still be created from the <code>absoluteURI</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, serverAddress, absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.web.client.WebClient#requestAbs} using the <code>serverAddress</code> parameter to connect to the
   * server instead of the <code>absoluteURI</code> parameter.
   * <p>
   * The request host header will still be created from the <code>absoluteURI</code> parameter.
   * <p>
   * Use  to connect to a unix domain socket server.
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> requestAbs(io.vertx.core.http.HttpMethod method, io.vertx.core.net.SocketAddress serverAddress, io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.requestAbs(method, serverAddress, absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> get(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.get(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> getAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.getAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP GET request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> getAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.getAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> post(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.post(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> postAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.postAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP POST request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absoluate URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> postAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.postAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> put(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.put(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> putAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.putAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PUT request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> putAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.putAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> delete(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.delete(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> deleteAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.deleteAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP DELETE request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> deleteAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.deleteAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patch(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patch(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patchAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patchAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP PATCH request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> patchAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.patchAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the default host and port.
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the default host and port.
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(int port, java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(port, host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and port.
   * @param port the port
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(int port, java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(port, host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(java.lang.String host, java.lang.String requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(host, requestURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server at the specified host and default port.
   * @param host the host
   * @param requestURI the request URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> head(java.lang.String host, io.vertx.reactivex.uritemplate.UriTemplate requestURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.head(host, requestURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> headAbs(java.lang.String absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.headAbs(absoluteURI), TypeArg.unknown());
    return ret;
  }

  /**
   * Create an HTTP HEAD request to send to the server using an absolute URI, specifying a response handler to receive
   * the response
   * @param absoluteURI the absolute URI as a 
   * @return an HTTP client request object
   */
  public io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> headAbs(io.vertx.reactivex.uritemplate.UriTemplate absoluteURI) { 
    io.vertx.reactivex.ext.web.client.HttpRequest<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.ext.web.client.HttpRequest.newInstance((io.vertx.ext.web.client.HttpRequest)delegate.headAbs(absoluteURI.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options).onComplete($handler);
    });
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.vertx.core.Future<java.lang.Boolean> updateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.updateSSLOptions(options, force).map(val -> val);
    return ret;
  }

  /**
   * <p>Update the client with new SSL <code>options</code>, the update happens if the options object is valid and different
   * from the existing options object.
   *
   * <p>The <code>options</code> object is compared using its <code>equals</code> method against the existing options to prevent
   * an update when the objects are equals since loading options can be costly, this can happen for share TCP servers.
   * When object are equals, setting <code>force</code> to <code>true</code> forces the update.
   *
   * <p>The boolean succeeded future result indicates whether the update occurred.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return a future signaling the update success
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.ClientSSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateSSLOptions(options, force).onComplete($handler);
    });
  }

  /**
   * Close the client. Closing will close down any pooled connections.
   * Clients should always be closed after use.
   */
  public void close() { 
    delegate.close();
  }

  public static WebClient newInstance(io.vertx.ext.web.client.WebClient arg) {
    return arg != null ? new WebClient(arg) : null;
  }

}
