/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.client;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous OAuth2/OIDC aware HTTP / HTTP/2 client called <code>WebClientOAuth2</code>.
 * <p>
 * This client wraps a {@link io.vertx.reactivex.ext.web.client.WebClient} and makes it session aware adding features to it:
 * <ul>
 *   <li>Request an <code>access_token</code> if no user is created</li>
 *   <li>Refresh <code>access_token</code> if current user is expired</li>
 * </ul>
 * <p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.OAuth2WebClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.OAuth2WebClient.class)
public class OAuth2WebClient extends io.vertx.reactivex.ext.web.client.WebClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2WebClient that = (OAuth2WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuth2WebClient> __TYPE_ARG = new TypeArg<>(    obj -> new OAuth2WebClient((io.vertx.ext.web.client.OAuth2WebClient) obj),
    OAuth2WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.OAuth2WebClient delegate;
  
  public OAuth2WebClient(io.vertx.ext.web.client.OAuth2WebClient delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OAuth2WebClient(Object delegate) {
    super((io.vertx.ext.web.client.OAuth2WebClient)delegate);
    this.delegate = (io.vertx.ext.web.client.OAuth2WebClient)delegate;
  }

  @Override 
  public io.vertx.ext.web.client.OAuth2WebClient getDelegate() {
    return delegate;
  }

  /**
   * Create a session aware web client using the provided <code>webClient</code> instance.
   * @param webClient the web client instance
   * @param oAuth2Auth Configured oAuth2Auth provider to be used when {@link io.vertx.reactivex.ext.web.client.OAuth2WebClient#withCredentials} used
   * @return the created client
   */
  public static io.vertx.reactivex.ext.web.client.OAuth2WebClient create(io.vertx.reactivex.ext.web.client.WebClient webClient, io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth oAuth2Auth) { 
    io.vertx.reactivex.ext.web.client.OAuth2WebClient ret = io.vertx.reactivex.ext.web.client.OAuth2WebClient.newInstance((io.vertx.ext.web.client.OAuth2WebClient)io.vertx.ext.web.client.OAuth2WebClient.create(webClient.getDelegate(), oAuth2Auth.getDelegate()));
    return ret;
  }

  /**
   * Create a session aware web client using the provided <code>webClient</code> instance.
   * @param webClient the web client instance
   * @param oAuth2Auth Configured oAuth2Auth provider to be used when {@link io.vertx.reactivex.ext.web.client.OAuth2WebClient#withCredentials} used
   * @param options extra configuration for this object
   * @return the created client
   */
  public static io.vertx.reactivex.ext.web.client.OAuth2WebClient create(io.vertx.reactivex.ext.web.client.WebClient webClient, io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth oAuth2Auth, io.vertx.ext.web.client.OAuth2WebClientOptions options) { 
    io.vertx.reactivex.ext.web.client.OAuth2WebClient ret = io.vertx.reactivex.ext.web.client.OAuth2WebClient.newInstance((io.vertx.ext.web.client.OAuth2WebClient)io.vertx.ext.web.client.OAuth2WebClient.create(webClient.getDelegate(), oAuth2Auth.getDelegate(), options));
    return ret;
  }

  /**
   * Get the authenticated user (if any) that is associated with this client.
   * @return the current user associated with this client or null if no user is associated
   */
  public io.vertx.reactivex.ext.auth.User getUser() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.getUser());
    return ret;
  }

  /**
   * Mark that request should be dispatched with authentication obtained from passed <code>OAuth2Auth</code> provider
   * @param credentials 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.client.OAuth2WebClient withCredentials(io.vertx.ext.auth.authentication.Credentials credentials) { 
    delegate.withCredentials(credentials);
    return this;
  }

  public static OAuth2WebClient newInstance(io.vertx.ext.web.client.OAuth2WebClient arg) {
    return arg != null ? new OAuth2WebClient(arg) : null;
  }

}
