/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A web user is extended user coupled to the context and is used to perform verifications
 * and actions on behalf of the user. Actions can be:
 *
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#refresh} - Require a re-authentication to confirm the user is present</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#impersonate} - Require a re-authentication to switch user identities</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#restore} - De-escalate a previous impersonate call</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#logout} - Logout the user from this application and redirect to a uri</li>
 *   <li>{@link io.vertx.reactivex.ext.web.UserContext#clear} - Same as logout, without requirind a redirect</li>
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.UserContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.UserContext.class)
public class UserContext implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserContext that = (UserContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UserContext> __TYPE_ARG = new TypeArg<>(    obj -> new UserContext((io.vertx.ext.web.UserContext) obj),
    UserContext::getDelegate
  );

  private final io.vertx.ext.web.UserContext delegate;
  
  public UserContext(io.vertx.ext.web.UserContext delegate) {
    this.delegate = delegate;
  }

  public UserContext(Object delegate) {
    this.delegate = (io.vertx.ext.web.UserContext)delegate;
  }

  @Override 
  public io.vertx.ext.web.UserContext getDelegate() {
    return delegate;
  }


  /**
   * Get the authenticated user (if any). This will usually be injected by an auth handler if authentication if successful.
   * @return the user, or null if the current user is not authenticated.
   */
  public io.vertx.reactivex.ext.auth.User get() { 
    io.vertx.reactivex.ext.auth.User ret = io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.get());
    return ret;
  }

  public boolean authenticated() { 
    boolean ret = delegate.authenticated();
    return ret;
  }

  /**
   * When performing a web identity operation, hint if possible to the identity provider to use the given login.
   * @param loginHint the desired login name, for example: <code>admin</code>.
   * @return fluent self
   */
  public io.vertx.reactivex.ext.web.UserContext loginHint(java.lang.String loginHint) { 
    delegate.loginHint(loginHint);
    return this;
  }

  /**
   * Forces the current user to re-authenticate. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> refresh() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.refresh().map(val -> val);
    return ret;
  }

  /**
   * Forces the current user to re-authenticate. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxRefresh() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.refresh().onComplete($handler);
    });
  }

  /**
   * Forces the current user to re-authenticate. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the re-authentication.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> refresh(java.lang.String redirectUri) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.refresh(redirectUri).map(val -> val);
    return ret;
  }

  /**
   * Forces the current user to re-authenticate. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the re-authentication.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxRefresh(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.refresh(redirectUri).onComplete($handler);
    });
  }

  /**
   * Impersonates a second identity. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> impersonate() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.impersonate().map(val -> val);
    return ret;
  }

  /**
   * Impersonates a second identity. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxImpersonate() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.impersonate().onComplete($handler);
    });
  }

  /**
   * Impersonates a second identity. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the authentication.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> impersonate(java.lang.String redirectUri) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.impersonate(redirectUri).map(val -> val);
    return ret;
  }

  /**
   * Impersonates a second identity. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the authentication.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxImpersonate(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.impersonate(redirectUri).onComplete($handler);
    });
  }

  /**
   *  Undo a previous call to a impersonation. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> restore() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.restore().map(val -> val);
    return ret;
  }

  /**
   *  Undo a previous call to a impersonation. The user will be redirected to the same origin where this call was
   * made. It is important to notice that the redirect will only allow sources originating from a HTTP GET request.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxRestore() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.restore().onComplete($handler);
    });
  }

  /**
   * Undo a previous call to an impersonation. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the re-authentication.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> restore(java.lang.String redirectUri) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.restore(redirectUri).map(val -> val);
    return ret;
  }

  /**
   * Undo a previous call to an impersonation. The user will be redirected to the given uri. It is important to
   * notice that the redirect will only allow targets using an HTTP GET request.
   * @param redirectUri the uri to redirect the user to after the re-authentication.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxRestore(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.restore(redirectUri).onComplete($handler);
    });
  }

  /**
   * Logout can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Followed by a
   * redirect to the given uri.
   * @param redirectUri the uri to redirect the user to after the logout.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> logout(java.lang.String redirectUri) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.logout(redirectUri).map(val -> val);
    return ret;
  }

  /**
   * Logout can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Followed by a
   * redirect to the given uri.
   * @param redirectUri the uri to redirect the user to after the logout.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxLogout(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.logout(redirectUri).onComplete($handler);
    });
  }

  /**
   * Logout can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Followed by a
   * redirect to <code>/</code>.
   * @return future result of the operation.
   */
  public io.vertx.core.Future<java.lang.Void> logout() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.logout().map(val -> val);
    return ret;
  }

  /**
   * Logout can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Followed by a
   * redirect to <code>/</code>.
   * @return future result of the operation.
   */
  public io.reactivex.Completable rxLogout() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.logout().onComplete($handler);
    });
  }

  /**
   * Clear can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.reactivex.ext.auth.User} and clear the {@link io.vertx.reactivex.ext.web.Session} (if any) in the current context. Unlike
   * {@link io.vertx.reactivex.ext.web.UserContext#logout} no redirect will be performed.
   */
  public void clear() { 
    delegate.clear();
  }

  public static UserContext newInstance(io.vertx.ext.web.UserContext arg) {
    return arg != null ? new UserContext(arg) : null;
  }

}
