/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a browser session.
 * <p>
 * Sessions persist between HTTP requests for a single browser session. They are deleted when the browser is closed, or
 * they time-out. Session cookies are used to maintain sessions using a secure UUID.
 * <p>
 * Sessions can be used to maintain data for a browser session, e.g. a shopping basket.
 * <p>
 * The context must have first been routed to a {@link io.vertx.reactivex.ext.web.handler.SessionHandler}
 * for sessions to be available.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.Session original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.Session.class)
public class Session implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Session that = (Session) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Session> __TYPE_ARG = new TypeArg<>(    obj -> new Session((io.vertx.ext.web.Session) obj),
    Session::getDelegate
  );

  private final io.vertx.ext.web.Session delegate;
  
  public Session(io.vertx.ext.web.Session delegate) {
    this.delegate = delegate;
  }

  public Session(Object delegate) {
    this.delegate = (io.vertx.ext.web.Session)delegate;
  }

  @Override 
  public io.vertx.ext.web.Session getDelegate() {
    return delegate;
  }


  /**
   * @return The new unique ID of the session.
   */
  public io.vertx.reactivex.ext.web.Session regenerateId() { 
    io.vertx.reactivex.ext.web.Session ret = io.vertx.reactivex.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.regenerateId());
    return ret;
  }

  /**
   * @return The unique ID of the session. This is generated using a random secure UUID.
   */
  public java.lang.String id() { 
    java.lang.String ret = delegate.id();
    return ret;
  }

  /**
   * Put some data in a session
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Session put(java.lang.String key, java.lang.Object obj) { 
    delegate.put(key, obj);
    return this;
  }

  /**
   * Put some data in a session if absent
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Session putIfAbsent(java.lang.String key, java.lang.Object obj) { 
    delegate.putIfAbsent(key, obj);
    return this;
  }

  /**
   * Put some data in a session if absent.
   *
   * If the specified key is not already associated with a value (or is mapped
   * to <code>null</code>), attempts to compute its value using the given mapping
   * function and enters it into this map unless <code>null</code>.
   * @param key the key for the data
   * @param mappingFunction a mapping function
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.ext.web.Session computeIfAbsent(java.lang.String key, java.util.function.Function<java.lang.String,java.lang.Object> mappingFunction) { 
    delegate.computeIfAbsent(key, mappingFunction);
    return this;
  }

  /**
   * Get some data from the session
   * @param key the key of the data
   * @return the data
   */
  public <T> T get(java.lang.String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * Remove some data from the session
   * @param key the key of the data
   * @return the data that was there or null if none there
   */
  public <T> T remove(java.lang.String key) { 
    T ret = (T) delegate.remove(key);
    return ret;
  }

  /**
   * @return true if the session has data
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return the time the session was last accessed
   */
  public long lastAccessed() { 
    long ret = delegate.lastAccessed();
    return ret;
  }

  /**
   * Destroy the session
   */
  public void destroy() { 
    delegate.destroy();
  }

  /**
   * @return has the session been destroyed?
   */
  public boolean isDestroyed() { 
    boolean ret = delegate.isDestroyed();
    return ret;
  }

  /**
   * @return has the session been renewed?
   */
  public boolean isRegenerated() { 
    boolean ret = delegate.isRegenerated();
    return ret;
  }

  /**
   * @return old ID if renewed
   */
  public java.lang.String oldId() { 
    java.lang.String ret = delegate.oldId();
    return ret;
  }

  /**
   * @return the amount of time in ms, after which the session will expire, if not accessed.
   */
  public long timeout() { 
    long ret = delegate.timeout();
    return ret;
  }

  /**
   * Mark the session as being accessed.
   */
  public void setAccessed() { 
    delegate.setAccessed();
  }

  /**
   * The short representation of the session to be added to the session cookie. By default is the session id.
   * @return short representation string.
   */
  public java.lang.String value() { 
    java.lang.String ret = delegate.value();
    return ret;
  }

  /**
   * @return the session data as a map
   */
  public java.util.Map<java.lang.String,java.lang.Object> data() { 
    java.util.Map<java.lang.String,java.lang.Object> ret = delegate.data();
    return ret;
  }

  public static Session newInstance(io.vertx.ext.web.Session arg) {
    return arg != null ? new Session(arg) : null;
  }

}
