/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.web.MIMEHeader.class)
public class MIMEHeader implements RxDelegate, io.vertx.reactivex.ext.web.ParsedHeaderValue {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MIMEHeader that = (MIMEHeader) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MIMEHeader> __TYPE_ARG = new TypeArg<>(    obj -> new MIMEHeader((io.vertx.ext.web.MIMEHeader) obj),
    MIMEHeader::getDelegate
  );

  private final io.vertx.ext.web.MIMEHeader delegate;
  
  public MIMEHeader(io.vertx.ext.web.MIMEHeader delegate) {
    this.delegate = delegate;
  }

  public MIMEHeader(Object delegate) {
    this.delegate = (io.vertx.ext.web.MIMEHeader)delegate;
  }

  @Override 
  public io.vertx.ext.web.MIMEHeader getDelegate() {
    return delegate;
  }


  /**
   * Contains the raw value that was received from the user agent
   * @return 
   */
  public java.lang.String rawValue() { 
    java.lang.String ret = delegate.rawValue();
    return ret;
  }

  /**
   * Holds the unparsed value of the header.<br>
   * For the most part, this is the content before the semi-colon (";")
   * @return 
   */
  public java.lang.String value() { 
    java.lang.String ret = delegate.value();
    return ret;
  }

  /**
   * Holds the weight specified in the "q" parameter of the header.<br>
   * If the parameter is not specified, 1.0 is assumed according to
   * <a href="https://tools.ietf.org/html/rfc7231#section-5.3.1">rfc7231</a>
   * @return 
   */
  public float weight() { 
    float ret = delegate.weight();
    return ret;
  }

  /**
   * The value of the parameter specified by this key. Each is one of 3 things:
   * <ol>
   * <li>null &lt;- That key was not specified</li>
   * <li>ParsedHeaderValue.EMPTY (tested using ==) &lt;- The value was not specified</li>
   * <li>[Other] <- The value of the parameter</li>
   * </ol>
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @param key 
   * @return 
   */
  public java.lang.String parameter(java.lang.String key) { 
    java.lang.String ret = delegate.parameter(key);
    return ret;
  }

  /**
   * The parameters specified in this header value.
   * <b>Note:</b> The <code>q</code> parameter is never present.
   * @return Unmodifiable Map of parameters of this header value
   */
  public java.util.Map<java.lang.String,java.lang.String> parameters() { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.parameters();
    return ret;
  }

  /**
   * Is this an allowed operation as specified by the corresponding header?
   * @return 
   */
  public boolean isPermitted() { 
    boolean ret = delegate.isPermitted();
    return ret;
  }

  /**
   * Test if this header is matched by matchTry header
   * @param matchTry The header to be matched from
   * @return true if this header represents a subset of matchTry, otherwise, false
   */
  public boolean isMatchedBy(io.vertx.reactivex.ext.web.ParsedHeaderValue matchTry) { 
    boolean ret = delegate.isMatchedBy(matchTry.getDelegate());
    return ret;
  }

  /**
   * An integer that represents the absolute order position of this header
   * @return 
   */
  public int weightedOrder() { 
    int ret = delegate.weightedOrder();
    return ret;
  }

  /**
   * Gets the parsed component part of the MIME. This is the string between the beginning and the first <code>'/'</code>
   * of the MIME
   * @return The component of the MIME this represents
   */
  public java.lang.String component() { 
    java.lang.String ret = delegate.component();
    return ret;
  }

  /**
   * Gets the parsed subcomponent part of the MIME. This is the string between the first <code>'/'</code> and the
   * <code>';'</code> or the end of the MIME
   * @return The subcomponent of the MIME this represents
   */
  public java.lang.String subComponent() { 
    java.lang.String ret = delegate.subComponent();
    return ret;
  }

  /**
   * Gets the MIME media type string.
   * This includes both the component and subcomponent parts of the MIME type.
   * @return The MIME media type string.
   */
  public java.lang.String mediaType() { 
    java.lang.String ret = delegate.mediaType();
    return ret;
  }

  /**
   * Gets the MIME media type string with parameters attached.
   * This includes both the component and subcomponent parts of the MIME type, and parameters.
   * @return The MIME media type string.
   */
  public java.lang.String mediaTypeWithParams() { 
    java.lang.String ret = delegate.mediaTypeWithParams();
    return ret;
  }

  /**
   * <quote>If no "q" parameter is present, the default weight is 1.</quote>
   */
  public static final float DEFAULT_WEIGHT = io.vertx.ext.web.MIMEHeader.DEFAULT_WEIGHT;
  public static MIMEHeader newInstance(io.vertx.ext.web.MIMEHeader arg) {
    return arg != null ? new MIMEHeader(arg) : null;
  }

}
