/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a file-upload from an HTTP multipart form submission.
 * <p>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.FileUpload original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.FileUpload.class)
public class FileUpload implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileUpload that = (FileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FileUpload> __TYPE_ARG = new TypeArg<>(    obj -> new FileUpload((io.vertx.ext.web.FileUpload) obj),
    FileUpload::getDelegate
  );

  private final io.vertx.ext.web.FileUpload delegate;
  
  public FileUpload(io.vertx.ext.web.FileUpload delegate) {
    this.delegate = delegate;
  }

  public FileUpload(Object delegate) {
    this.delegate = (io.vertx.ext.web.FileUpload)delegate;
  }

  @Override 
  public io.vertx.ext.web.FileUpload getDelegate() {
    return delegate;
  }


  /**
   * @return the name of the upload as provided in the form submission
   */
  public java.lang.String name() { 
    java.lang.String ret = delegate.name();
    return ret;
  }

  /**
   * @return the actual temporary file name on the server where the file was uploaded to.
   */
  public java.lang.String uploadedFileName() { 
    java.lang.String ret = delegate.uploadedFileName();
    return ret;
  }

  /**
   * @return the file name of the upload as provided in the form submission
   */
  public java.lang.String fileName() { 
    java.lang.String ret = delegate.fileName();
    return ret;
  }

  /**
   * @return the size of the upload, in bytes
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return the content type (MIME type) of the upload
   */
  public java.lang.String contentType() { 
    java.lang.String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the content transfer encoding of the upload - this describes how the upload was encoded in the form submission.
   */
  public java.lang.String contentTransferEncoding() { 
    java.lang.String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset of the upload
   */
  public java.lang.String charSet() { 
    java.lang.String ret = delegate.charSet();
    return ret;
  }

  /**
   * Try to cancel the file upload.
   * @return <code>true</code> when the upload was cancelled, <code>false</code> when the upload is finished and the file is available
   */
  public boolean cancel() { 
    boolean ret = delegate.cancel();
    return ret;
  }

  /**
   * Delete the uploaded file on the disk.
   * @return a future signaling when the file has been deleted
   */
  public io.vertx.core.Future<java.lang.Void> delete() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.delete().map(val -> val);
    return ret;
  }

  /**
   * Delete the uploaded file on the disk.
   * @return a future signaling when the file has been deleted
   */
  public io.reactivex.Completable rxDelete() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.delete().onComplete($handler);
    });
  }

  public static FileUpload newInstance(io.vertx.ext.web.FileUpload arg) {
    return arg != null ? new FileUpload(arg) : null;
  }

}
