/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.unit.report;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The result of a test.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.report.TestResult original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.report.TestResult.class)
public class TestResult implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TestResult that = (TestResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TestResult> __TYPE_ARG = new TypeArg<>(    obj -> new TestResult((io.vertx.ext.unit.report.TestResult) obj),
    TestResult::getDelegate
  );

  private final io.vertx.ext.unit.report.TestResult delegate;
  
  public TestResult(io.vertx.ext.unit.report.TestResult delegate) {
    this.delegate = delegate;
  }

  public TestResult(Object delegate) {
    this.delegate = (io.vertx.ext.unit.report.TestResult)delegate;
  }

  @Override 
  public io.vertx.ext.unit.report.TestResult getDelegate() {
    return delegate;
  }

  /**
   * The test description, may be null if none was provided.
   * @return 
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  /**
   * The time at which the test began in millis.
   * @return 
   */
  public long beginTime() { 
    if (cached_1 != null) {
      return cached_1;
    }
    long ret = delegate.beginTime();
    cached_1 = ret;
    return ret;
  }

  /**
   * How long the test lasted in millis.
   * @return 
   */
  public long durationTime() { 
    if (cached_2 != null) {
      return cached_2;
    }
    long ret = delegate.durationTime();
    cached_2 = ret;
    return ret;
  }

  /**
   * Did it succeed?
   * @return 
   */
  public boolean succeeded() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.succeeded();
    cached_3 = ret;
    return ret;
  }

  /**
   * Did it fail?
   * @return 
   */
  public boolean failed() { 
    if (cached_4 != null) {
      return cached_4;
    }
    boolean ret = delegate.failed();
    cached_4 = ret;
    return ret;
  }

  /**
   * An exception describing failure, null if the test succeeded.
   * @return 
   */
  public io.vertx.reactivex.ext.unit.report.Failure failure() { 
    if (cached_5 != null) {
      return cached_5;
    }
    io.vertx.reactivex.ext.unit.report.Failure ret = io.vertx.reactivex.ext.unit.report.Failure.newInstance((io.vertx.ext.unit.report.Failure)delegate.failure());
    cached_5 = ret;
    return ret;
  }

  private java.lang.String cached_0;
  private java.lang.Long cached_1;
  private java.lang.Long cached_2;
  private java.lang.Boolean cached_3;
  private java.lang.Boolean cached_4;
  private io.vertx.reactivex.ext.unit.report.Failure cached_5;
  public static TestResult newInstance(io.vertx.ext.unit.report.TestResult arg) {
    return arg != null ? new TestResult(arg) : null;
  }

}
