/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.unit;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A completion object that emits completion notifications either <i>succeeded</i> or <i>failed</i>.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.unit.Completion original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.unit.Completion.class)
public class Completion<T> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Completion that = (Completion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Completion> __TYPE_ARG = new TypeArg<>(    obj -> new Completion((io.vertx.ext.unit.Completion) obj),
    Completion::getDelegate
  );

  private final io.vertx.ext.unit.Completion<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public Completion(io.vertx.ext.unit.Completion delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public Completion(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.ext.unit.Completion)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.ext.unit.Completion getDelegate() {
    return delegate;
  }

  /**
   * Completes the future upon completion, otherwise fails it.
   * @param future the future to resolve
   */
  public void resolve(io.vertx.reactivex.core.Promise<T> future) { 
    delegate.resolve(future.getDelegate());
  }

  /**
   * @return true if this completion is completed
   */
  public boolean isCompleted() { 
    boolean ret = delegate.isCompleted();
    return ret;
  }

  /**
   * @return true if this completion is completed and succeeded
   */
  public boolean isSucceeded() { 
    boolean ret = delegate.isSucceeded();
    return ret;
  }

  /**
   * @return true if the this completion is completed and failed
   */
  public boolean isFailed() { 
    boolean ret = delegate.isFailed();
    return ret;
  }

  /**
   * Cause the current thread to wait until this completion completes.<p/>
   *
   * If the current thread is interrupted, an exception will be thrown.
   */
  public void await() { 
    delegate.await();
  }

  /**
   * Cause the current thread to wait until this completion completes with a configurable timeout.<p/>
   *
   * If completion times out or the current thread is interrupted, an exception will be thrown.
   * @param timeoutMillis the timeout in milliseconds
   */
  public void await(long timeoutMillis) { 
    delegate.await(timeoutMillis);
  }

  /**
   * Cause the current thread to wait until this completion completes and succeeds.<p/>
   *
   * If the current thread is interrupted or the suite fails, an exception will be thrown.
   */
  public void awaitSuccess() { 
    delegate.awaitSuccess();
  }

  /**
   * Cause the current thread to wait until this completion completes and succeeds with a configurable timeout.<p/>
   *
   * If completion times out or the current thread is interrupted or the suite fails, an exception will be thrown.
   * @param timeoutMillis the timeout in milliseconds
   */
  public void awaitSuccess(long timeoutMillis) { 
    delegate.awaitSuccess(timeoutMillis);
  }

  /**
   * Completion handler to receive a completion signal when this completions completes.
   * @param completionHandler the completion handler
   */
  public void handler(io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> completionHandler) { 
    delegate.handler(completionHandler);
  }

  public static <T> Completion<T> newInstance(io.vertx.ext.unit.Completion arg) {
    return arg != null ? new Completion<T>(arg) : null;
  }

  public static <T> Completion<T> newInstance(io.vertx.ext.unit.Completion arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new Completion<T>(arg, __typeArg_T) : null;
  }

}
