/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.stomp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Structure passed to acknowledgement handler called when a <code>ACK</code> or <code>NACK</code> frame is received. The handler
 * receives an instance of {@link io.vertx.reactivex.ext.stomp.Acknowledgement} with the subscription {@link io.vertx.ext.stomp.Frame} and the impacted messages. The
 * list of messages depends on the type of acknowledgment used by the subscription.
 * <p/>
 * Subscriptions using the <code>client</code> mode receives all messages that were waiting for acknowledgment that were
 * sent before the acknowledged messages. The list also contains the acknowledged message. This is a cumulative
 * acknowledgement. Subscriptions using the <code>client-individual</code> mode receives a singleton list containing only
 * the acknowledged message.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.stomp.Acknowledgement original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.stomp.Acknowledgement.class)
public class Acknowledgement implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Acknowledgement that = (Acknowledgement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Acknowledgement> __TYPE_ARG = new TypeArg<>(    obj -> new Acknowledgement((io.vertx.ext.stomp.Acknowledgement) obj),
    Acknowledgement::getDelegate
  );

  private final io.vertx.ext.stomp.Acknowledgement delegate;
  
  public Acknowledgement(io.vertx.ext.stomp.Acknowledgement delegate) {
    this.delegate = delegate;
  }

  public Acknowledgement(Object delegate) {
    this.delegate = (io.vertx.ext.stomp.Acknowledgement)delegate;
  }

  @Override 
  public io.vertx.ext.stomp.Acknowledgement getDelegate() {
    return delegate;
  }


  /**
   * @return the subscription frame
   */
  public io.vertx.ext.stomp.Frame subscription() { 
    io.vertx.ext.stomp.Frame ret = delegate.subscription();
    return ret;
  }

  /**
   * @return the list of frames that have been acknowledged / not-acknowledged. The content of the list depends on the type of subscription.
   */
  public java.util.List<io.vertx.ext.stomp.Frame> frames() { 
    java.util.List<io.vertx.ext.stomp.Frame> ret = delegate.frames();
    return ret;
  }

  public static Acknowledgement newInstance(io.vertx.ext.stomp.Acknowledgement arg) {
    return arg != null ? new Acknowledgement(arg) : null;
  }

}
