/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoGridFsClient that = (MongoGridFsClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg<>(    obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient) obj),
    MongoGridFsClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoGridFsClient delegate;
  
  public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
    this.delegate = delegate;
  }

  public MongoGridFsClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
  }

  @Override 
  public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
    return delegate;
  }


  /**
   * Deletes a file by it's ID
   * @param id the identifier of the file
   * @return a future notified when the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> delete(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.delete(id).map(val -> val);
    return ret;
  }

  /**
   * Deletes a file by it's ID
   * @param id the identifier of the file
   * @return a future notified when the operation completes
   */
  public io.reactivex.Completable rxDelete(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.delete(id).onComplete($handler);
    });
  }

  /**
   * Read file by name to ReadStream
   * @param fileName 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> readByFileName(java.lang.String fileName) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileName(fileName), TypeArg.unknown());
    return ret;
  }

  /**
   * Read file by name to ReadStream with options
   * @param fileName 
   * @param options 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> readByFileNameWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readByFileNameWithOptions(fileName, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Read file by id to ReadStream
   * @param id 
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> readById(java.lang.String id) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.readById(id), TypeArg.unknown());
    return ret;
  }

  public io.vertx.core.Future<java.lang.Long> downloadByFileName(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadByFileName(stream.getDelegate(), fileName).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadByFileName(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadByFileName(stream, fileName).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.Long> downloadByFileNameWithOptions(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadByFileNameWithOptions(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsDownloadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadByFileNameWithOptions(stream, fileName, options).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.Long> downloadById(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String id) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadById(stream.getDelegate(), id).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.Long> rxDownloadById(io.vertx.reactivex.core.streams.WriteStream<io.vertx.core.buffer.Buffer> stream, java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadById(stream, id).onComplete($handler);
    });
  }

  /**
   * Downloads a file.
   * @param fileName the name of the file to download
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Long> downloadFile(java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadFile(fileName).map(val -> val);
    return ret;
  }

  /**
   * Downloads a file.
   * @param fileName the name of the file to download
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFile(java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadFile(fileName).onComplete($handler);
    });
  }

  /**
   * Downloads a file and gives it a new name.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Long> downloadFileAs(java.lang.String fileName, java.lang.String newFileName) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadFileAs(fileName, newFileName).map(val -> val);
    return ret;
  }

  /**
   * Downloads a file and gives it a new name.
   * @param fileName the name of the file to download
   * @param newFileName the name the file should be saved as
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFileAs(java.lang.String fileName, java.lang.String newFileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadFileAs(fileName, newFileName).onComplete($handler);
    });
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.Long> downloadFileByID(java.lang.String id, java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.downloadFileByID(id, fileName).map(val -> val);
    return ret;
  }

  /**
   * Downloads a file using the ID generated by GridFs.
   * @param id the GridFs Object ID of the file to download
   * @param fileName 
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.lang.Long> rxDownloadFileByID(java.lang.String id, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.downloadFileByID(id, fileName).onComplete($handler);
    });
  }

  /**
   * Drops the entire file bucket with all of its contents
   * @return a future notified when the operation completes
   */
  public io.vertx.core.Future<java.lang.Void> drop() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.drop().map(val -> val);
    return ret;
  }

  /**
   * Drops the entire file bucket with all of its contents
   * @return a future notified when the operation completes
   */
  public io.reactivex.Completable rxDrop() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.drop().onComplete($handler);
    });
  }

  /**
   * Finds all file ids in the bucket
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> findAllIds() { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.findAllIds().map(val -> val);
    return ret;
  }

  /**
   * Finds all file ids in the bucket
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxFindAllIds() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.findAllIds().onComplete($handler);
    });
  }

  /**
   * Finds all file ids that match a query.
   * @param query a bson query expressed as json that will be used to match files
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> findIds(io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.findIds(query).map(val -> val);
    return ret;
  }

  /**
   * Finds all file ids that match a query.
   * @param query a bson query expressed as json that will be used to match files
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxFindIds(io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.findIds(query).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.String> uploadByFileName(io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadByFileName(stream.getDelegate(), fileName).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileName(io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadByFileName(stream, fileName).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.String> uploadByFileName(io.reactivex.Flowable<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadByFileName(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj).resume(), fileName).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileName(io.reactivex.Flowable<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadByFileName(stream, fileName).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.String> uploadByFileNameWithOptions(io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadByFileNameWithOptions(stream.getDelegate(), fileName, options).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileNameWithOptions(io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadByFileNameWithOptions(stream, fileName, options).onComplete($handler);
    });
  }

  public io.vertx.core.Future<java.lang.String> uploadByFileNameWithOptions(io.reactivex.Flowable<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadByFileNameWithOptions(io.vertx.reactivex.impl.ReadStreamSubscriber.asReadStream(stream, obj -> obj).resume(), fileName, options).map(val -> val);
    return ret;
  }

  public io.reactivex.Single<java.lang.String> rxUploadByFileNameWithOptions(io.reactivex.Flowable<io.vertx.core.buffer.Buffer> stream, java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadByFileNameWithOptions(stream, fileName, options).onComplete($handler);
    });
  }

  /**
   * Upload a file to gridfs
   * @param fileName the name of the file to store in gridfs
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.String> uploadFile(java.lang.String fileName) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadFile(fileName).map(val -> val);
    return ret;
  }

  /**
   * Upload a file to gridfs
   * @param fileName the name of the file to store in gridfs
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.lang.String> rxUploadFile(java.lang.String fileName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadFile(fileName).onComplete($handler);
    });
  }

  /**
   * Upload a file to gridfs with options
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return a future notified with the result
   */
  public io.vertx.core.Future<java.lang.String> uploadFileWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.uploadFileWithOptions(fileName, options).map(val -> val);
    return ret;
  }

  /**
   * Upload a file to gridfs with options
   * @param fileName the name of the file to store in gridfs
   * @param options {@link io.vertx.ext.mongo.GridFsUploadOptions} for specifying metadata and chunk size
   * @return a future notified with the result
   */
  public io.reactivex.Single<java.lang.String> rxUploadFileWithOptions(java.lang.String fileName, io.vertx.ext.mongo.GridFsUploadOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.uploadFileWithOptions(fileName, options).onComplete($handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
    return arg != null ? new MongoGridFsClient(arg) : null;
  }

}
