/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with MongoDB server instances.
 * <p>
 * Some of the operations might change <i>_id</i> field of passed  document.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.mongo.MongoClient.class)
public class MongoClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoClient that = (MongoClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg<>(    obj -> new MongoClient((io.vertx.ext.mongo.MongoClient) obj),
    MongoClient::getDelegate
  );

  private final io.vertx.ext.mongo.MongoClient delegate;
  
  public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
    this.delegate = delegate;
  }

  public MongoClient(Object delegate) {
    this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
  }

  @Override 
  public io.vertx.ext.mongo.MongoClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.mongo.MongoGridFsClient> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.mongo.MongoGridFsClient>(o1 -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.mongo.MongoGridFsClient> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.mongo.MongoGridFsClient>(o1 -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)o1), o1 -> o1.getDelegate());

  /**
   * Create a Mongo client which maintains its own data source.
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Create a Mongo client which shares its data source with any other Mongo clients created with the same
   * data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param dataSourceName the data source name
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config, java.lang.String dataSourceName) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config, dataSourceName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.ext.mongo.MongoClient#createShared} but with the default data source name
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.reactivex.ext.mongo.MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.core.json.JsonObject config) { 
    io.vertx.reactivex.ext.mongo.MongoClient ret = io.vertx.reactivex.ext.mongo.MongoClient.newInstance((io.vertx.ext.mongo.MongoClient)io.vertx.ext.mongo.MongoClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return a future provided with the id if document didn't already have one
   */
  public io.vertx.core.Future<java.lang.String> save(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.save(collection, document).map(val -> val);
    return ret;
  }

  /**
   * Save a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return a future provided with the id if document didn't already have one
   */
  public io.reactivex.Maybe<java.lang.String> rxSave(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.save(collection, document).onComplete($handler);
    });
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return a future provided with the id if document didn't already have one
   */
  public io.vertx.core.Future<java.lang.String> saveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.saveWithOptions(collection, document, writeOption).map(val -> val);
    return ret;
  }

  /**
   * Save a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return a future provided with the id if document didn't already have one
   */
  public io.reactivex.Maybe<java.lang.String> rxSaveWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.saveWithOptions(collection, document, writeOption).onComplete($handler);
    });
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return a future provided with the id if document didn't already have one
   */
  public io.vertx.core.Future<java.lang.String> insert(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.insert(collection, document).map(val -> val);
    return ret;
  }

  /**
   * Insert a document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @return a future provided with the id if document didn't already have one
   */
  public io.reactivex.Maybe<java.lang.String> rxInsert(java.lang.String collection, io.vertx.core.json.JsonObject document) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.insert(collection, document).onComplete($handler);
    });
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return a future provided with the id if document didn't already have one
   */
  public io.vertx.core.Future<java.lang.String> insertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.insertWithOptions(collection, document, writeOption).map(val -> val);
    return ret;
  }

  /**
   * Insert a document in the specified collection with the specified write option
   * <p>
   * This operation might change <i>_id</i> field of <i>document</i> parameter
   * @param collection the collection
   * @param document the document
   * @param writeOption the write option to use
   * @return a future provided with the id if document didn't already have one
   */
  public io.reactivex.Maybe<java.lang.String> rxInsertWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject document, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.insertWithOptions(collection, document, writeOption).onComplete($handler);
    });
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.updateCollection(collection, query, update).map(val -> val);
    return ret;
  }

  /**
   * Update matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.updateCollection(collection, query, update).onComplete($handler);
    });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.updateCollection(collection, query, update).map(val -> val);
    return ret;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollection(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.updateCollection(collection, query, update).onComplete($handler);
    });
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.updateCollectionWithOptions(collection, query, update, options).map(val -> val);
    return ret;
  }

  /**
   * Update matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update used to describe how the documents will be updated
   * @param options options to configure the update
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.updateCollectionWithOptions(collection, query, update, options).onComplete($handler);
    });
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> updateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.updateCollectionWithOptions(collection, query, update, options).map(val -> val);
    return ret;
  }

  /**
   * Use an aggregation pipeline to update documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param update aggregation pipeline used to describe how documents will be updated
   * @param options options to configure the update
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxUpdateCollectionWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonArray update, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.updateCollectionWithOptions(collection, query, update, options).onComplete($handler);
    });
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> replaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.replaceDocuments(collection, query, replace).map(val -> val);
    return ret;
  }

  /**
   * Replace matching documents in the specified collection and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replaceDocuments(collection, query, replace).onComplete($handler);
    });
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> replaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientUpdateResult> ret = delegate.replaceDocumentsWithOptions(collection, query, replace, options).map(val -> val);
    return ret;
  }

  /**
   * Replace matching documents in the specified collection, specifying options and return the handler with <code>MongoClientUpdateResult</code> result
   * @param collection the collection
   * @param query query used to match the documents
   * @param replace all matching documents will be replaced with this
   * @param options options to configure the replace
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientUpdateResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientUpdateResult> rxReplaceDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.UpdateOptions options) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.replaceDocumentsWithOptions(collection, query, replace, options).onComplete($handler);
    });
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientBulkWriteResult> bulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientBulkWriteResult> ret = delegate.bulkWrite(collection, operations).map(val -> val);
    return ret;
  }

  /**
   * Execute a bulk operation. Can insert, update, replace, and/or delete multiple documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWrite(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bulkWrite(collection, operations).onComplete($handler);
    });
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientBulkWriteResult> bulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientBulkWriteResult> ret = delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions).map(val -> val);
    return ret;
  }

  /**
   * Execute a bulk operation with the specified write options. Can insert, update, replace, and/or delete multiple
   * documents with one request.
   * @param collection the collection
   * @param operations the operations to execute
   * @param bulkWriteOptions the write options
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientBulkWriteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientBulkWriteResult> rxBulkWriteWithOptions(java.lang.String collection, java.util.List<io.vertx.ext.mongo.BulkOperation> operations, io.vertx.ext.mongo.BulkWriteOptions bulkWriteOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.bulkWriteWithOptions(collection, operations, bulkWriteOptions).onComplete($handler);
    });
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return a future provided with list of documents
   */
  public io.vertx.core.Future<java.util.List<io.vertx.core.json.JsonObject>> find(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<java.util.List<io.vertx.core.json.JsonObject>> ret = delegate.find(collection, query).map(val -> val);
    return ret;
  }

  /**
   * Find matching documents in the specified collection
   * @param collection the collection
   * @param query query used to match documents
   * @return a future provided with list of documents
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFind(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.find(collection, query).onComplete($handler);
    });
  }

  /**
   * Find matching documents in the specified collection.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatch(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatch(collection, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a future provided with list of documents
   */
  public io.vertx.core.Future<java.util.List<io.vertx.core.json.JsonObject>> findWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    io.vertx.core.Future<java.util.List<io.vertx.core.json.JsonObject>> ret = delegate.findWithOptions(collection, query, options).map(val -> val);
    return ret;
  }

  /**
   * Find matching documents in the specified collection, specifying options
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a future provided with list of documents
   */
  public io.reactivex.Single<java.util.List<io.vertx.core.json.JsonObject>> rxFindWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.findWithOptions(collection, query, options).onComplete($handler);
    });
  }

  /**
   * Find matching documents in the specified collection, specifying options.
   * This method use batchCursor for returning each found document.
   * @param collection the collection
   * @param query query used to match documents
   * @param options options to configure the find
   * @return a  emitting found documents
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> findBatchWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return a future provided with the document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOne(collection, query, fields).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param fields the fields
   * @return a future provided with the document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOne(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject fields) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOne(collection, query, fields).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return a future provided with the document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndUpdate(collection, query, update).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @return a future provided with the document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndUpdate(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndUpdate(collection, query, update).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return a future provided with the document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and update it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param update used to describe how the documents will be updated
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return a future provided with the document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndUpdateWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject update, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return a future provided with the document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndReplace(collection, query, replace).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @return a future provided with the document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndReplace(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndReplace(collection, query, replace).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return a future provided with the document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and replace it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param replace the replacement document
   * @param findOptions options to configure the find
   * @param updateOptions options to configure the update
   * @return a future provided with the document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndReplaceWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.core.json.JsonObject replace, io.vertx.ext.mongo.FindOptions findOptions, io.vertx.ext.mongo.UpdateOptions updateOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return a future provided with the deleted document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndDelete(collection, query).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @return a future provided with the deleted document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndDelete(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndDelete(collection, query).onComplete($handler);
    });
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return a future provided with the deleted document, if any
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> findOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.findOneAndDeleteWithOptions(collection, query, findOptions).map(val -> val);
    return ret;
  }

  /**
   * Find a single matching document in the specified collection and delete it.
   * <p>
   * This operation might change <i>_id</i> field of <i>query</i> parameter
   * @param collection the collection
   * @param query the query used to match the document
   * @param findOptions options to configure the find
   * @return a future provided with the deleted document, if any
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxFindOneAndDeleteWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.FindOptions findOptions) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.findOneAndDeleteWithOptions(collection, query, findOptions).onComplete($handler);
    });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return a future provided with the number of matching documents
   */
  public io.vertx.core.Future<java.lang.Long> count(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.count(collection, query).map(val -> val);
    return ret;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @return a future provided with the number of matching documents
   */
  public io.reactivex.Single<java.lang.Long> rxCount(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.count(collection, query).onComplete($handler);
    });
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return a future provided with the number of matching documents
   */
  public io.vertx.core.Future<java.lang.Long> countWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    io.vertx.core.Future<java.lang.Long> ret = delegate.countWithOptions(collection, query, countOptions).map(val -> val);
    return ret;
  }

  /**
   * Count matching documents in a collection.
   * @param collection the collection
   * @param query query used to match documents
   * @param countOptions 
   * @return a future provided with the number of matching documents
   */
  public io.reactivex.Single<java.lang.Long> rxCountWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.CountOptions countOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.countWithOptions(collection, query, countOptions).onComplete($handler);
    });
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> ret = delegate.removeDocuments(collection, query).map(val -> val);
    return ret;
  }

  /**
   * Remove matching documents from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocuments(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.removeDocuments(collection, query).onComplete($handler);
    });
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> ret = delegate.removeDocumentsWithOptions(collection, query, writeOption).map(val -> val);
    return ret;
  }

  /**
   * Remove matching documents from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match documents
   * @param writeOption the write option to use
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentsWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.removeDocumentsWithOptions(collection, query, writeOption).onComplete($handler);
    });
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> ret = delegate.removeDocument(collection, query).map(val -> val);
    return ret;
  }

  /**
   * Remove a single matching document from a collection and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocument(java.lang.String collection, io.vertx.core.json.JsonObject query) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.removeDocument(collection, query).onComplete($handler);
    });
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> removeDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    io.vertx.core.Future<io.vertx.ext.mongo.MongoClientDeleteResult> ret = delegate.removeDocumentWithOptions(collection, query, writeOption).map(val -> val);
    return ret;
  }

  /**
   * Remove a single matching document from a collection with the specified write option and return the handler with <code>MongoClientDeleteResult</code> result
   * @param collection the collection
   * @param query query used to match document
   * @param writeOption the write option to use
   * @return a future notified with a {@link io.vertx.ext.mongo.MongoClientDeleteResult} when complete
   */
  public io.reactivex.Maybe<io.vertx.ext.mongo.MongoClientDeleteResult> rxRemoveDocumentWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.WriteOption writeOption) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.removeDocumentWithOptions(collection, query, writeOption).onComplete($handler);
    });
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return a future notified once complete
   */
  public io.vertx.core.Future<java.lang.Void> createCollection(java.lang.String collectionName) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createCollection(collectionName).map(val -> val);
    return ret;
  }

  /**
   * Create a new collection
   * @param collectionName the name of the collection
   * @return a future notified once complete
   */
  public io.reactivex.Completable rxCreateCollection(java.lang.String collectionName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createCollection(collectionName).onComplete($handler);
    });
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return a future notified once complete
   */
  public io.vertx.core.Future<java.lang.Void> createCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createCollectionWithOptions(collectionName, collectionOptions).map(val -> val);
    return ret;
  }

  /**
   * Create a new collection with options
   * @param collectionName the name of the collection
   * @param collectionOptions options of the collection
   * @return a future notified once complete
   */
  public io.reactivex.Completable rxCreateCollectionWithOptions(java.lang.String collectionName, io.vertx.ext.mongo.CreateCollectionOptions collectionOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createCollectionWithOptions(collectionName, collectionOptions).onComplete($handler);
    });
  }

  /**
   * Get a list of all collections in the database.
   * @return a future notified with a list of collections.
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> getCollections() { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.getCollections().map(val -> val);
    return ret;
  }

  /**
   * Get a list of all collections in the database.
   * @return a future notified with a list of collections.
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetCollections() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getCollections().onComplete($handler);
    });
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> dropCollection(java.lang.String collection) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.dropCollection(collection).map(val -> val);
    return ret;
  }

  /**
   * Drop a collection
   * @param collection the collection
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDropCollection(java.lang.String collection) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.dropCollection(collection).onComplete($handler);
    });
  }

  /**
   * Rename a collection
   * @param oldCollectionName the name of the collection
   * @param newCollectionName the new name of the collection
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> renameCollection(java.lang.String oldCollectionName, java.lang.String newCollectionName) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.renameCollection(oldCollectionName, newCollectionName).map(val -> val);
    return ret;
  }

  /**
   * Rename a collection
   * @param oldCollectionName the name of the collection
   * @param newCollectionName the new name of the collection
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxRenameCollection(java.lang.String oldCollectionName, java.lang.String newCollectionName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.renameCollection(oldCollectionName, newCollectionName).onComplete($handler);
    });
  }

  /**
   * Rename a collection
   * @param oldCollectionName the name of the collection
   * @param newCollectionName the new name of the collection
   * @param collectionOptions options of the collection
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> renameCollectionWithOptions(java.lang.String oldCollectionName, java.lang.String newCollectionName, io.vertx.ext.mongo.RenameCollectionOptions collectionOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.renameCollectionWithOptions(oldCollectionName, newCollectionName, collectionOptions).map(val -> val);
    return ret;
  }

  /**
   * Rename a collection
   * @param oldCollectionName the name of the collection
   * @param newCollectionName the new name of the collection
   * @param collectionOptions options of the collection
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxRenameCollectionWithOptions(java.lang.String oldCollectionName, java.lang.String newCollectionName, io.vertx.ext.mongo.RenameCollectionOptions collectionOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.renameCollectionWithOptions(oldCollectionName, newCollectionName, collectionOptions).onComplete($handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> createIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createIndex(collection, key).map(val -> val);
    return ret;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxCreateIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createIndex(collection, key).onComplete($handler);
    });
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> createIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createIndexWithOptions(collection, key, options).map(val -> val);
    return ret;
  }

  /**
   * Creates an index.
   * @param collection the collection
   * @param key A document that contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @param options the options for the index
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxCreateIndexWithOptions(java.lang.String collection, io.vertx.core.json.JsonObject key, io.vertx.ext.mongo.IndexOptions options) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createIndexWithOptions(collection, key, options).onComplete($handler);
    });
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> createIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.createIndexes(collection, indexes).map(val -> val);
    return ret;
  }

  /**
   * creates an indexes
   * @param collection the collection
   * @param indexes A model that contains pairs of document and indexOptions, document contains the field and value pairs where the field is the index key and the value describes the type of index for that field. For an ascending index on a field, specify a value of 1; for descending index, specify a value of -1.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxCreateIndexes(java.lang.String collection, java.util.List<io.vertx.ext.mongo.IndexModel> indexes) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.createIndexes(collection, indexes).onComplete($handler);
    });
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return a future notified when complete
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonArray> listIndexes(java.lang.String collection) { 
    io.vertx.core.Future<io.vertx.core.json.JsonArray> ret = delegate.listIndexes(collection).map(val -> val);
    return ret;
  }

  /**
   * Get all the indexes in this collection.
   * @param collection the collection
   * @return a future notified when complete
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxListIndexes(java.lang.String collection) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listIndexes(collection).onComplete($handler);
    });
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> dropIndex(java.lang.String collection, java.lang.String indexName) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.dropIndex(collection, indexName).map(val -> val);
    return ret;
  }

  /**
   * Drops the index given its name.
   * @param collection the collection
   * @param indexName the name of the index to remove
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDropIndex(java.lang.String collection, java.lang.String indexName) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.dropIndex(collection, indexName).onComplete($handler);
    });
  }

  /**
   * Drops the index given the keys used to create it.
   * @param collection the collection
   * @param key the key(s) of the index to remove
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> dropIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.dropIndex(collection, key).map(val -> val);
    return ret;
  }

  /**
   * Drops the index given the keys used to create it.
   * @param collection the collection
   * @param key the key(s) of the index to remove
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDropIndex(java.lang.String collection, io.vertx.core.json.JsonObject key) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.dropIndex(collection, key).onComplete($handler);
    });
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return a future notified with the result.
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> runCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.runCommand(commandName, command).map(val -> val);
    return ret;
  }

  /**
   * Run an arbitrary MongoDB command.
   * @param commandName the name of the command
   * @param command the command
   * @return a future notified with the result.
   */
  public io.reactivex.Maybe<io.vertx.core.json.JsonObject> rxRunCommand(java.lang.String commandName, io.vertx.core.json.JsonObject command) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      this.runCommand(commandName, command).onComplete($handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a future provided with array of values.
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonArray> distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    io.vertx.core.Future<io.vertx.core.json.JsonArray> ret = delegate.distinct(collection, fieldName, resultClassname).map(val -> val);
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a future provided with array of values.
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.distinct(collection, fieldName, resultClassname).onComplete($handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a future provided with array of values.
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonArray> distinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.core.Future<io.vertx.core.json.JsonArray> ret = delegate.distinct(collection, fieldName, resultClassname, distinctOptions).map(val -> val);
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a future provided with array of values.
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinct(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.distinct(collection, fieldName, resultClassname, distinctOptions).onComplete($handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a future provided with array of values.
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonArray> distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    io.vertx.core.Future<io.vertx.core.json.JsonArray> ret = delegate.distinctWithQuery(collection, fieldName, resultClassname, query).map(val -> val);
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a future provided with array of values.
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.distinctWithQuery(collection, fieldName, resultClassname, query).onComplete($handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a future provided with array of values.
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonArray> distinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.core.Future<io.vertx.core.json.JsonArray> ret = delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).map(val -> val);
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * Return a JsonArray containing distinct values (eg: [ 1 , 89 ])
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a future provided with array of values.
   */
  public io.reactivex.Single<io.vertx.core.json.JsonArray> rxDistinctWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).onComplete($handler);
    });
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatch(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * Gets the distinct values of the specified field name filtered by specified query.
   * This method use batchCursor for returning each found value.
   * Each value is a json fragment with fieldName key (eg: {"num": 1}).
   * @param collection the collection
   * @param fieldName the field name
   * @param resultClassname 
   * @param query the query
   * @param batchSize the number of documents to load in a batch
   * @param distinctOptions options (e.g. collation)
   * @return a  emitting json fragments
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> distinctBatchWithQuery(java.lang.String collection, java.lang.String fieldName, java.lang.String resultClassname, io.vertx.core.json.JsonObject query, int batchSize, io.vertx.ext.mongo.DistinctOptions distinctOptions) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command with default {@link io.vertx.ext.mongo.AggregateOptions}.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregate(java.lang.String collection, io.vertx.core.json.JsonArray pipeline) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregate(collection, pipeline), TypeArg.unknown());
    return ret;
  }

  /**
   * Run aggregate MongoDB command.
   * @param collection the collection
   * @param pipeline aggregation pipeline to be executed
   * @param options options to configure the aggregation command
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> aggregateWithOptions(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, io.vertx.ext.mongo.AggregateOptions options) { 
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.core.json.JsonObject> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
    return ret;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return a future notified with the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoGridFsClient> createDefaultGridFsBucketService() { 
    io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoGridFsClient> ret = delegate.createDefaultGridFsBucketService().map(val -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)val));
    return ret;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @return a future notified with the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoGridFsClient> rxCreateDefaultGridFsBucketService() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createDefaultGridFsBucketService().onComplete($handler);
    });
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return a future notified with the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoGridFsClient> createGridFsBucketService(java.lang.String bucketName) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.mongo.MongoGridFsClient> ret = delegate.createGridFsBucketService(bucketName).map(val -> io.vertx.reactivex.ext.mongo.MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)val));
    return ret;
  }

  /**
   * Creates a {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} used to interact with Mongo GridFS.
   * @param bucketName the name of the GridFS bucket
   * @return a future notified with the {@link io.vertx.reactivex.ext.mongo.MongoGridFsClient} to interact with the bucket named bucketName
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.mongo.MongoGridFsClient> rxCreateGridFsBucketService(java.lang.String bucketName) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createGridFsBucketService(bucketName).onComplete($handler);
    });
  }

  /**
   * Close the client and release its resources
   * @return 
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the client and release its resources
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  /**
   * Watch the collection change.
   * @param collection the collection
   * @param pipeline watching pipeline to be executed
   * @param withUpdatedDoc whether to get updated fullDocument for "update" operation
   * @param batchSize the number of documents to load in a batch
   * @return 
   */
  public io.vertx.reactivex.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> watch(java.lang.String collection, io.vertx.core.json.JsonArray pipeline, boolean withUpdatedDoc, int batchSize) { 
    io.vertx.reactivex.core.streams.ReadStream<com.mongodb.client.model.changestream.ChangeStreamDocument<io.vertx.core.json.JsonObject>> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
    return ret;
  }

  /**
   * The name of the default pool
   */
  public static final java.lang.String DEFAULT_POOL_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_POOL_NAME;
  /**
   * The name of the default database
   */
  public static final java.lang.String DEFAULT_DB_NAME = io.vertx.ext.mongo.MongoClient.DEFAULT_DB_NAME;
  public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
    return arg != null ? new MongoClient(arg) : null;
  }

}
