/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.eventbus.bridge.tcp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * TCP EventBus bridge for Vert.x
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.class)
public class TcpEventBusBridge implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TcpEventBusBridge that = (TcpEventBusBridge) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TcpEventBusBridge> __TYPE_ARG = new TypeArg<>(    obj -> new TcpEventBusBridge((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge) obj),
    TcpEventBusBridge::getDelegate
  );

  private final io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate;
  
  public TcpEventBusBridge(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate) {
    this.delegate = delegate;
  }

  public TcpEventBusBridge(Object delegate) {
    this.delegate = (io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)delegate;
  }

  @Override 
  public io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge>(o1 -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge>(o1 -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge>(o1 -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> TYPE_ARG_3 = new TypeArg<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge>(o1 -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)o1), o1 -> o1.getDelegate());

  public static io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options) { 
    io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options));
    return ret;
  }

  public static io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions) { 
    io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions));
    return ret;
  }

  public static io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions, io.vertx.core.Handler<io.vertx.reactivex.ext.eventbus.bridge.tcp.BridgeEvent> eventHandler) { 
    io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions, io.vertx.lang.reactivex.Helper.convertHandler(eventHandler, event -> io.vertx.reactivex.ext.eventbus.bridge.tcp.BridgeEvent.newInstance((io.vertx.ext.eventbus.bridge.tcp.BridgeEvent)event))));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen() { 
    io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = delegate.listen().map(val -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)val));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen().onComplete($handler);
    });
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @param port the tcp port
   * @param address the local address
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen(int port, java.lang.String address) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = delegate.listen(port, address).map(val -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)val));
    return ret;
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @param port the tcp port
   * @param address the local address
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port, java.lang.String address) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port, address).onComplete($handler);
    });
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @param port the TCP port
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen(int port) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = delegate.listen(port).map(val -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)val));
    return ret;
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * @param port the TCP port
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(port).onComplete($handler);
    });
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the  used when creating the server.
   * @param localAddress the local address to listen on
   * @return a future of the result
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen(io.vertx.core.net.SocketAddress localAddress) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = delegate.listen(localAddress).map(val -> io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)val));
    return ret;
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the  used when creating the server.
   * @param localAddress the local address to listen on
   * @return a future of the result
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(io.vertx.core.net.SocketAddress localAddress) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listen(localAddress).onComplete($handler);
    });
  }

  /**
   * Close the current socket.
   * @return a future of the result
   */
  public io.vertx.core.Future<java.lang.Void> close() { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.close().map(val -> val);
    return ret;
  }

  /**
   * Close the current socket.
   * @return a future of the result
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.close().onComplete($handler);
    });
  }

  public static TcpEventBusBridge newInstance(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge arg) {
    return arg != null ? new TcpEventBusBridge(arg) : null;
  }

}
