/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.consul;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConsulClient> __TYPE_ARG = new TypeArg<>(    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public ConsulClient(Object delegate) {
    this.delegate = (io.vertx.ext.consul.ConsulClient)delegate;
  }

  @Override 
  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }


  /**
   * Create a Consul client with default options.
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Consul client.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.ext.consul.ConsulClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.consul.ConsulClientOptions options) { 
    io.vertx.reactivex.ext.consul.ConsulClient ret = io.vertx.reactivex.ext.consul.ConsulClient.newInstance((io.vertx.ext.consul.ConsulClient)io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return a future provided with the configuration and member information of the local agent
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> agentInfo() { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.agentInfo().map(val -> val);
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return a future provided with the configuration and member information of the local agent
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxAgentInfo() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.agentInfo().onComplete($handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return a future provided with network coordinates of nodes in datacenter
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CoordinateList> coordinateNodes() { 
    io.vertx.core.Future<io.vertx.ext.consul.CoordinateList> ret = delegate.coordinateNodes().map(val -> val);
    return ret;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return a future provided with network coordinates of nodes in datacenter
   */
  public io.reactivex.Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodes() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.coordinateNodes().onComplete($handler);
    });
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return a future provided with network coordinates of nodes in datacenter
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CoordinateList> coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.CoordinateList> ret = delegate.coordinateNodesWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return a future provided with network coordinates of nodes in datacenter
   */
  public io.reactivex.Single<io.vertx.ext.consul.CoordinateList> rxCoordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.coordinateNodesWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return a future provided with network coordinates for all Consul servers
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.DcCoordinates>> coordinateDatacenters() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.DcCoordinates>> ret = delegate.coordinateDatacenters().map(val -> val);
    return ret;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return a future provided with network coordinates for all Consul servers
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.DcCoordinates>> rxCoordinateDatacenters() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.coordinateDatacenters().onComplete($handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return a future provided with keys list
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> getKeys(java.lang.String keyPrefix) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.getKeys(keyPrefix).map(val -> val);
    return ret;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return a future provided with keys list
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetKeys(java.lang.String keyPrefix) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getKeys(keyPrefix).onComplete($handler);
    });
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return a future provided with keys list
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> getKeysWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.getKeysWithOptions(keyPrefix, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return a future provided with keys list
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxGetKeysWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getKeysWithOptions(keyPrefix, options).onComplete($handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return a future provided with key/value pair
   */
  public io.vertx.core.Future<io.vertx.ext.consul.KeyValue> getValue(java.lang.String key) { 
    io.vertx.core.Future<io.vertx.ext.consul.KeyValue> ret = delegate.getValue(key).map(val -> val);
    return ret;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return a future provided with key/value pair
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValue> rxGetValue(java.lang.String key) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getValue(key).onComplete($handler);
    });
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return a future provided with key/value pair
   */
  public io.vertx.core.Future<io.vertx.ext.consul.KeyValue> getValueWithOptions(java.lang.String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.KeyValue> ret = delegate.getValueWithOptions(key, options).map(val -> val);
    return ret;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return a future provided with key/value pair
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValue> rxGetValueWithOptions(java.lang.String key, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getValueWithOptions(key, options).onComplete($handler);
    });
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return a future notified on complete
   */
  public io.vertx.core.Future<java.lang.Void> deleteValue(java.lang.String key) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deleteValue(key).map(val -> val);
    return ret;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return a future notified on complete
   */
  public io.reactivex.Completable rxDeleteValue(java.lang.String key) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deleteValue(key).onComplete($handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return a future provided with list of key/value pairs
   */
  public io.vertx.core.Future<io.vertx.ext.consul.KeyValueList> getValues(java.lang.String keyPrefix) { 
    io.vertx.core.Future<io.vertx.ext.consul.KeyValueList> ret = delegate.getValues(keyPrefix).map(val -> val);
    return ret;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return a future provided with list of key/value pairs
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValueList> rxGetValues(java.lang.String keyPrefix) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getValues(keyPrefix).onComplete($handler);
    });
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return a future provided with list of key/value pairs
   */
  public io.vertx.core.Future<io.vertx.ext.consul.KeyValueList> getValuesWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.KeyValueList> ret = delegate.getValuesWithOptions(keyPrefix, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return a future provided with list of key/value pairs
   */
  public io.reactivex.Single<io.vertx.ext.consul.KeyValueList> rxGetValuesWithOptions(java.lang.String keyPrefix, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getValuesWithOptions(keyPrefix, options).onComplete($handler);
    });
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return a future notified on complete
   */
  public io.vertx.core.Future<java.lang.Void> deleteValues(java.lang.String keyPrefix) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deleteValues(keyPrefix).map(val -> val);
    return ret;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return a future notified on complete
   */
  public io.reactivex.Completable rxDeleteValues(java.lang.String keyPrefix) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deleteValues(keyPrefix).onComplete($handler);
    });
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return a future provided with success of operation
   */
  public io.vertx.core.Future<java.lang.Boolean> putValue(java.lang.String key, java.lang.String value) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.putValue(key, value).map(val -> val);
    return ret;
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return a future provided with success of operation
   */
  public io.reactivex.Single<java.lang.Boolean> rxPutValue(java.lang.String key, java.lang.String value) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.putValue(key, value).onComplete($handler);
    });
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return a future provided with success of operation
   */
  public io.vertx.core.Future<java.lang.Boolean> putValueWithOptions(java.lang.String key, java.lang.String value, io.vertx.ext.consul.KeyValueOptions options) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.putValueWithOptions(key, value, options).map(val -> val);
    return ret;
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return a future provided with success of operation
   */
  public io.reactivex.Single<java.lang.Boolean> rxPutValueWithOptions(java.lang.String key, java.lang.String value, io.vertx.ext.consul.KeyValueOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.putValueWithOptions(key, value, options).onComplete($handler);
    });
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return a future provided with result of transaction
   */
  public io.vertx.core.Future<io.vertx.ext.consul.TxnResponse> transaction(io.vertx.ext.consul.TxnRequest request) { 
    io.vertx.core.Future<io.vertx.ext.consul.TxnResponse> ret = delegate.transaction(request).map(val -> val);
    return ret;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return a future provided with result of transaction
   */
  public io.reactivex.Single<io.vertx.ext.consul.TxnResponse> rxTransaction(io.vertx.ext.consul.TxnRequest request) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.transaction(request).onComplete($handler);
    });
  }

  /**
   * Creates a new ACL policy
   * @param policy properties of policy
   * @return a future provided with ID of created policy
   */
  public io.vertx.core.Future<java.lang.String> createAclPolicy(io.vertx.ext.consul.policy.AclPolicy policy) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.createAclPolicy(policy).map(val -> val);
    return ret;
  }

  /**
   * Creates a new ACL policy
   * @param policy properties of policy
   * @return a future provided with ID of created policy
   */
  public io.reactivex.Single<java.lang.String> rxCreateAclPolicy(io.vertx.ext.consul.policy.AclPolicy policy) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createAclPolicy(policy).onComplete($handler);
    });
  }

  /**
   * This endpoint reads an ACL policy with the given ID
   * @param id uuid policy
   * @return a future of AclPolicy
   */
  public io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> readPolicy(java.lang.String id) { 
    io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> ret = delegate.readPolicy(id).map(val -> val);
    return ret;
  }

  /**
   * This endpoint reads an ACL policy with the given ID
   * @param id uuid policy
   * @return a future of AclPolicy
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxReadPolicy(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.readPolicy(id).onComplete($handler);
    });
  }

  /**
   * This endpoint reads an ACL policy with the given name
   * @param name unique name of created policy
   * @return a future of AclPolicy like in {@link io.vertx.reactivex.ext.consul.ConsulClient#readPolicy}
   */
  public io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> readPolicyByName(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> ret = delegate.readPolicyByName(name).map(val -> val);
    return ret;
  }

  /**
   * This endpoint reads an ACL policy with the given name
   * @param name unique name of created policy
   * @return a future of AclPolicy like in {@link io.vertx.reactivex.ext.consul.ConsulClient#readPolicy}
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxReadPolicyByName(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.readPolicyByName(name).onComplete($handler);
    });
  }

  /**
   * This endpoint updates an existing ACL policy
   * @param id uuid of existing policy
   * @param policy options that will be applied to the existing policy
   * @return a future of AclPolicy
   */
  public io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> updatePolicy(java.lang.String id, io.vertx.ext.consul.policy.AclPolicy policy) { 
    io.vertx.core.Future<io.vertx.ext.consul.policy.AclPolicy> ret = delegate.updatePolicy(id, policy).map(val -> val);
    return ret;
  }

  /**
   * This endpoint updates an existing ACL policy
   * @param id uuid of existing policy
   * @param policy options that will be applied to the existing policy
   * @return a future of AclPolicy
   */
  public io.reactivex.Single<io.vertx.ext.consul.policy.AclPolicy> rxUpdatePolicy(java.lang.String id, io.vertx.ext.consul.policy.AclPolicy policy) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updatePolicy(id, policy).onComplete($handler);
    });
  }

  /**
   * This endpoint deletes an ACL policy
   * @param id uuid of existing policy
   * @return a future boolean value: true or false, indicating whether the deletion was successful
   */
  public io.vertx.core.Future<java.lang.Boolean> deletePolicy(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.deletePolicy(id).map(val -> val);
    return ret;
  }

  /**
   * This endpoint deletes an ACL policy
   * @param id uuid of existing policy
   * @return a future boolean value: true or false, indicating whether the deletion was successful
   */
  public io.reactivex.Single<java.lang.Boolean> rxDeletePolicy(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deletePolicy(id).onComplete($handler);
    });
  }

  /**
   * This endpoint lists all the ACL policies.
   * Note - The policies rules are not included in the listing and must be retrieved by the policy reading endpoint
   * @return a future of all acl policies
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.policy.AclPolicy>> getAclPolicies() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.policy.AclPolicy>> ret = delegate.getAclPolicies().map(val -> val);
    return ret;
  }

  /**
   * This endpoint lists all the ACL policies.
   * Note - The policies rules are not included in the listing and must be retrieved by the policy reading endpoint
   * @return a future of all acl policies
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.policy.AclPolicy>> rxGetAclPolicies() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getAclPolicies().onComplete($handler);
    });
  }

  /**
   * Create an Acl token
   * @param token properties of the token
   * @return a future NewAclToken in which two fields accessorId and secretId.  accessorId - required in the URL path or JSON body for getting, updating and cloning token.  secretId - using in {@link io.vertx.ext.consul.ConsulClientOptions}.
   */
  public io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> createAclToken(io.vertx.ext.consul.token.AclToken token) { 
    io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> ret = delegate.createAclToken(token).map(val -> val);
    return ret;
  }

  /**
   * Create an Acl token
   * @param token properties of the token
   * @return a future NewAclToken in which two fields accessorId and secretId.  accessorId - required in the URL path or JSON body for getting, updating and cloning token.  secretId - using in {@link io.vertx.ext.consul.ConsulClientOptions}.
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxCreateAclToken(io.vertx.ext.consul.token.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createAclToken(token).onComplete($handler);
    });
  }

  /**
   * Update an existing Acl token
   * @param accessorId uuid of the token
   * @param token properties of the token
   * @return a future NewAclToken like in {@link io.vertx.reactivex.ext.consul.ConsulClient#createAclToken}
   */
  public io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> updateAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.AclToken token) { 
    io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> ret = delegate.updateAclToken(accessorId, token).map(val -> val);
    return ret;
  }

  /**
   * Update an existing Acl token
   * @param accessorId uuid of the token
   * @param token properties of the token
   * @return a future NewAclToken like in {@link io.vertx.reactivex.ext.consul.ConsulClient#createAclToken}
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxUpdateAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.AclToken token) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.updateAclToken(accessorId, token).onComplete($handler);
    });
  }

  /**
   * Clones an existing ACL token
   * @param accessorId uuid of the token
   * @param cloneAclTokenOptions properties of cloned token
   * @return a future NewAclToken like in {@link io.vertx.reactivex.ext.consul.ConsulClient#createAclToken}
   */
  public io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> cloneAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.CloneAclTokenOptions cloneAclTokenOptions) { 
    io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> ret = delegate.cloneAclToken(accessorId, cloneAclTokenOptions).map(val -> val);
    return ret;
  }

  /**
   * Clones an existing ACL token
   * @param accessorId uuid of the token
   * @param cloneAclTokenOptions properties of cloned token
   * @return a future NewAclToken like in {@link io.vertx.reactivex.ext.consul.ConsulClient#createAclToken}
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxCloneAclToken(java.lang.String accessorId, io.vertx.ext.consul.token.CloneAclTokenOptions cloneAclTokenOptions) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.cloneAclToken(accessorId, cloneAclTokenOptions).onComplete($handler);
    });
  }

  /**
   * Get list of Acl token
   * @return a future provided with list of tokens
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.token.AclToken>> getAclTokens() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.token.AclToken>> ret = delegate.getAclTokens().map(val -> val);
    return ret;
  }

  /**
   * Get list of Acl token
   * @return a future provided with list of tokens
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.token.AclToken>> rxGetAclTokens() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getAclTokens().onComplete($handler);
    });
  }

  /**
   * Reads an ACL token with the given Accessor ID
   * @param accessorId uuid of token
   * @return a future provided with token
   */
  public io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> readAclToken(java.lang.String accessorId) { 
    io.vertx.core.Future<io.vertx.ext.consul.token.AclToken> ret = delegate.readAclToken(accessorId).map(val -> val);
    return ret;
  }

  /**
   * Reads an ACL token with the given Accessor ID
   * @param accessorId uuid of token
   * @return a future provided with token
   */
  public io.reactivex.Single<io.vertx.ext.consul.token.AclToken> rxReadAclToken(java.lang.String accessorId) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.readAclToken(accessorId).onComplete($handler);
    });
  }

  /**
   * Deletes an ACL token
   * @param accessorId uuid of token
   * @return a future boolean value: true or false, indicating whether the deletion was successful.
   */
  public io.vertx.core.Future<java.lang.Boolean> deleteAclToken(java.lang.String accessorId) { 
    io.vertx.core.Future<java.lang.Boolean> ret = delegate.deleteAclToken(accessorId).map(val -> val);
    return ret;
  }

  /**
   * Deletes an ACL token
   * @param accessorId uuid of token
   * @return a future boolean value: true or false, indicating whether the deletion was successful.
   */
  public io.reactivex.Single<java.lang.Boolean> rxDeleteAclToken(java.lang.String accessorId) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.deleteAclToken(accessorId).onComplete($handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return a future provided with properties of event
   */
  public io.vertx.core.Future<io.vertx.ext.consul.Event> fireEvent(java.lang.String name) { 
    io.vertx.core.Future<io.vertx.ext.consul.Event> ret = delegate.fireEvent(name).map(val -> val);
    return ret;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return a future provided with properties of event
   */
  public io.reactivex.Single<io.vertx.ext.consul.Event> rxFireEvent(java.lang.String name) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.fireEvent(name).onComplete($handler);
    });
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return a future provided with properties of event
   */
  public io.vertx.core.Future<io.vertx.ext.consul.Event> fireEventWithOptions(java.lang.String name, io.vertx.ext.consul.EventOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.Event> ret = delegate.fireEventWithOptions(name, options).map(val -> val);
    return ret;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return a future provided with properties of event
   */
  public io.reactivex.Single<io.vertx.ext.consul.Event> rxFireEventWithOptions(java.lang.String name, io.vertx.ext.consul.EventOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.fireEventWithOptions(name, options).onComplete($handler);
    });
  }

  /**
   * Returns the most recent events known by the agent
   * @return a future provided with list of events
   */
  public io.vertx.core.Future<io.vertx.ext.consul.EventList> listEvents() { 
    io.vertx.core.Future<io.vertx.ext.consul.EventList> ret = delegate.listEvents().map(val -> val);
    return ret;
  }

  /**
   * Returns the most recent events known by the agent
   * @return a future provided with list of events
   */
  public io.reactivex.Single<io.vertx.ext.consul.EventList> rxListEvents() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listEvents().onComplete($handler);
    });
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return a future provided with list of events
   */
  public io.vertx.core.Future<io.vertx.ext.consul.EventList> listEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.EventList> ret = delegate.listEventsWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return a future provided with list of events
   */
  public io.reactivex.Single<io.vertx.ext.consul.EventList> rxListEventsWithOptions(io.vertx.ext.consul.EventListOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listEventsWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> registerService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.registerService(serviceOptions).map(val -> val);
    return ret;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxRegisterService(io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.registerService(serviceOptions).onComplete($handler);
    });
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> maintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.maintenanceService(maintenanceOptions).map(val -> val);
    return ret;
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxMaintenanceService(io.vertx.ext.consul.MaintenanceOptions maintenanceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.maintenanceService(maintenanceOptions).onComplete($handler);
    });
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> deregisterService(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deregisterService(id).map(val -> val);
    return ret;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDeregisterService(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deregisterService(id).onComplete($handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return a future provided with list of nodes providing given service
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogServiceNodes(java.lang.String service) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogServiceNodes(service).map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return a future provided with list of nodes providing given service
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodes(java.lang.String service) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogServiceNodes(service).onComplete($handler);
    });
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return a future provided with list of nodes providing given service
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogServiceNodesWithOptions(java.lang.String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogServiceNodesWithOptions(service, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return a future provided with list of nodes providing given service
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServiceNodesWithOptions(java.lang.String service, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogServiceNodesWithOptions(service, options).onComplete($handler);
    });
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return a future provided with list of datacenters
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> catalogDatacenters() { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.catalogDatacenters().map(val -> val);
    return ret;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return a future provided with list of datacenters
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxCatalogDatacenters() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogDatacenters().onComplete($handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return a future provided with list of nodes
   */
  public io.vertx.core.Future<io.vertx.ext.consul.NodeList> catalogNodes() { 
    io.vertx.core.Future<io.vertx.ext.consul.NodeList> ret = delegate.catalogNodes().map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return a future provided with list of nodes
   */
  public io.reactivex.Single<io.vertx.ext.consul.NodeList> rxCatalogNodes() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogNodes().onComplete($handler);
    });
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return a future provided with list of nodes
   */
  public io.vertx.core.Future<io.vertx.ext.consul.NodeList> catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.NodeList> ret = delegate.catalogNodesWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return a future provided with list of nodes
   */
  public io.reactivex.Single<io.vertx.ext.consul.NodeList> rxCatalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogNodesWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return a future provided with list of checks
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CheckList> healthChecks(java.lang.String service) { 
    io.vertx.core.Future<io.vertx.ext.consul.CheckList> ret = delegate.healthChecks(service).map(val -> val);
    return ret;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return a future provided with list of checks
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthChecks(java.lang.String service) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthChecks(service).onComplete($handler);
    });
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return a future provided with list of checks
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CheckList> healthChecksWithOptions(java.lang.String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.CheckList> ret = delegate.healthChecksWithOptions(service, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return a future provided with list of checks
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthChecksWithOptions(java.lang.String service, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthChecksWithOptions(service, options).onComplete($handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return a future provided with list of checks
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CheckList> healthState(io.vertx.ext.consul.HealthState healthState) { 
    io.vertx.core.Future<io.vertx.ext.consul.CheckList> ret = delegate.healthState(healthState).map(val -> val);
    return ret;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @return a future provided with list of checks
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthState(io.vertx.ext.consul.HealthState healthState) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthState(healthState).onComplete($handler);
    });
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return a future provided with list of checks
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CheckList> healthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.CheckList> ret = delegate.healthStateWithOptions(healthState, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the checks in the specified status
   * @param healthState the health state
   * @param options options used to request checks
   * @return a future provided with list of checks
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthStateWithOptions(io.vertx.ext.consul.HealthState healthState, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthStateWithOptions(healthState, options).onComplete($handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceEntryList> healthServiceNodes(java.lang.String service, boolean passing) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceEntryList> ret = delegate.healthServiceNodes(service, passing).map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodes(java.lang.String service, boolean passing) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthServiceNodes(service, passing).onComplete($handler);
    });
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceEntryList> healthServiceNodesWithOptions(java.lang.String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceEntryList> ret = delegate.healthServiceNodesWithOptions(service, passing, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceEntryList> rxHealthServiceNodesWithOptions(java.lang.String service, boolean passing, io.vertx.ext.consul.ServiceQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthServiceNodesWithOptions(service, passing, options).onComplete($handler);
    });
  }

  /**
   * Returns the checks specific to the node provided on the path.
   * @param node the node name or ID
   * @param options options used to request node health checks
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.CheckList> healthNodesWithOptions(java.lang.String node, io.vertx.ext.consul.CheckQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.CheckList> ret = delegate.healthNodesWithOptions(node, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the checks specific to the node provided on the path.
   * @param node the node name or ID
   * @param options options used to request node health checks
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.CheckList> rxHealthNodesWithOptions(java.lang.String node, io.vertx.ext.consul.CheckQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.healthNodesWithOptions(node, options).onComplete($handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogServices() { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogServices().map(val -> val);
    return ret;
  }

  /**
   * Returns the services registered in a datacenter
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServices() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogServices().onComplete($handler);
    });
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogServicesWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogServicesWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogNodeServices(java.lang.String node) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogNodeServices(node).map(val -> val);
    return ret;
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServices(java.lang.String node) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogNodeServices(node).onComplete($handler);
    });
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<io.vertx.ext.consul.ServiceList> catalogNodeServicesWithOptions(java.lang.String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.ServiceList> ret = delegate.catalogNodeServicesWithOptions(node, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return a future provided with list of services
   */
  public io.reactivex.Single<io.vertx.ext.consul.ServiceList> rxCatalogNodeServicesWithOptions(java.lang.String node, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.catalogNodeServicesWithOptions(node, options).onComplete($handler);
    });
  }

  /**
   * Returns list of services registered with the local agent.
   * @return a future provided with list of services
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.Service>> localServices() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.Service>> ret = delegate.localServices().map(val -> val);
    return ret;
  }

  /**
   * Returns list of services registered with the local agent.
   * @return a future provided with list of services
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.Service>> rxLocalServices() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.localServices().onComplete($handler);
    });
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return a future provided with list of checks
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.Check>> localChecks() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.Check>> ret = delegate.localChecks().map(val -> val);
    return ret;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return a future provided with list of checks
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.Check>> rxLocalChecks() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.localChecks().onComplete($handler);
    });
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> registerCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.registerCheck(checkOptions).map(val -> val);
    return ret;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxRegisterCheck(io.vertx.ext.consul.CheckOptions checkOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.registerCheck(checkOptions).onComplete($handler);
    });
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> deregisterCheck(java.lang.String checkId) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deregisterCheck(checkId).map(val -> val);
    return ret;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDeregisterCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deregisterCheck(checkId).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> passCheck(java.lang.String checkId) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.passCheck(checkId).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxPassCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.passCheck(checkId).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> passCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.passCheckWithNote(checkId, note).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxPassCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.passCheckWithNote(checkId, note).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> warnCheck(java.lang.String checkId) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.warnCheck(checkId).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxWarnCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.warnCheck(checkId).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> warnCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.warnCheckWithNote(checkId, note).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxWarnCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.warnCheckWithNote(checkId, note).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> failCheck(java.lang.String checkId) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.failCheck(checkId).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxFailCheck(java.lang.String checkId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.failCheck(checkId).onComplete($handler);
    });
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> failCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.failCheckWithNote(checkId, note).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxFailCheckWithNote(java.lang.String checkId, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.failCheckWithNote(checkId, note).onComplete($handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> updateCheck(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.updateCheck(checkId, status).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxUpdateCheck(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.updateCheck(checkId, status).onComplete($handler);
    });
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> updateCheckWithNote(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, java.lang.String note) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.updateCheckWithNote(checkId, status, note).map(val -> val);
    return ret;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note specifies a human-readable message. This will be passed through to the check's <code>Output</code> field.
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxUpdateCheckWithNote(java.lang.String checkId, io.vertx.ext.consul.CheckStatus status, java.lang.String note) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.updateCheckWithNote(checkId, status, note).onComplete($handler);
    });
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return a future provided with address of cluster leader
   */
  public io.vertx.core.Future<java.lang.String> leaderStatus() { 
    io.vertx.core.Future<java.lang.String> ret = delegate.leaderStatus().map(val -> val);
    return ret;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return a future provided with address of cluster leader
   */
  public io.reactivex.Single<java.lang.String> rxLeaderStatus() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.leaderStatus().onComplete($handler);
    });
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return a future provided with list of peers
   */
  public io.vertx.core.Future<java.util.List<java.lang.String>> peersStatus() { 
    io.vertx.core.Future<java.util.List<java.lang.String>> ret = delegate.peersStatus().map(val -> val);
    return ret;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return a future provided with list of peers
   */
  public io.reactivex.Single<java.util.List<java.lang.String>> rxPeersStatus() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.peersStatus().onComplete($handler);
    });
  }

  /**
   * Initialize a new session
   * @return a future provided with ID of new session
   */
  public io.vertx.core.Future<java.lang.String> createSession() { 
    io.vertx.core.Future<java.lang.String> ret = delegate.createSession().map(val -> val);
    return ret;
  }

  /**
   * Initialize a new session
   * @return a future provided with ID of new session
   */
  public io.reactivex.Single<java.lang.String> rxCreateSession() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createSession().onComplete($handler);
    });
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return a future provided with ID of new session
   */
  public io.vertx.core.Future<java.lang.String> createSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.createSessionWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return a future provided with ID of new session
   */
  public io.reactivex.Single<java.lang.String> rxCreateSessionWithOptions(io.vertx.ext.consul.SessionOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createSessionWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return a future provided with info of requested session
   */
  public io.vertx.core.Future<io.vertx.ext.consul.Session> infoSession(java.lang.String id) { 
    io.vertx.core.Future<io.vertx.ext.consul.Session> ret = delegate.infoSession(id).map(val -> val);
    return ret;
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return a future provided with info of requested session
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxInfoSession(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.infoSession(id).onComplete($handler);
    });
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return a future provided with info of requested session
   */
  public io.vertx.core.Future<io.vertx.ext.consul.Session> infoSessionWithOptions(java.lang.String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.Session> ret = delegate.infoSessionWithOptions(id, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return a future provided with info of requested session
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxInfoSessionWithOptions(java.lang.String id, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.infoSessionWithOptions(id, options).onComplete($handler);
    });
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return a future provided with info of renewed session
   */
  public io.vertx.core.Future<io.vertx.ext.consul.Session> renewSession(java.lang.String id) { 
    io.vertx.core.Future<io.vertx.ext.consul.Session> ret = delegate.renewSession(id).map(val -> val);
    return ret;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return a future provided with info of renewed session
   */
  public io.reactivex.Single<io.vertx.ext.consul.Session> rxRenewSession(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.renewSession(id).onComplete($handler);
    });
  }

  /**
   * Returns the active sessions
   * @return a future provided with list of sessions
   */
  public io.vertx.core.Future<io.vertx.ext.consul.SessionList> listSessions() { 
    io.vertx.core.Future<io.vertx.ext.consul.SessionList> ret = delegate.listSessions().map(val -> val);
    return ret;
  }

  /**
   * Returns the active sessions
   * @return a future provided with list of sessions
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListSessions() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listSessions().onComplete($handler);
    });
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return a future provided with list of sessions
   */
  public io.vertx.core.Future<io.vertx.ext.consul.SessionList> listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.SessionList> ret = delegate.listSessionsWithOptions(options).map(val -> val);
    return ret;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return a future provided with list of sessions
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listSessionsWithOptions(options).onComplete($handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return a future provided with list of sessions
   */
  public io.vertx.core.Future<io.vertx.ext.consul.SessionList> listNodeSessions(java.lang.String nodeId) { 
    io.vertx.core.Future<io.vertx.ext.consul.SessionList> ret = delegate.listNodeSessions(nodeId).map(val -> val);
    return ret;
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return a future provided with list of sessions
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListNodeSessions(java.lang.String nodeId) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listNodeSessions(nodeId).onComplete($handler);
    });
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return a future provided with list of sessions
   */
  public io.vertx.core.Future<io.vertx.ext.consul.SessionList> listNodeSessionsWithOptions(java.lang.String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.SessionList> ret = delegate.listNodeSessionsWithOptions(nodeId, options).map(val -> val);
    return ret;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.reactivex.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return a future provided with list of sessions
   */
  public io.reactivex.Single<io.vertx.ext.consul.SessionList> rxListNodeSessionsWithOptions(java.lang.String nodeId, io.vertx.ext.consul.BlockingQueryOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.listNodeSessionsWithOptions(nodeId, options).onComplete($handler);
    });
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> destroySession(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.destroySession(id).map(val -> val);
    return ret;
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDestroySession(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.destroySession(id).onComplete($handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @return a future provided with id of created prepare query
   */
  public io.vertx.core.Future<java.lang.String> createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    io.vertx.core.Future<java.lang.String> ret = delegate.createPreparedQuery(definition).map(val -> val);
    return ret;
  }

  /**
   * @param definition definition of the prepare query
   * @return a future provided with id of created prepare query
   */
  public io.reactivex.Single<java.lang.String> rxCreatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createPreparedQuery(definition).onComplete($handler);
    });
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return a future provided with definition of the prepare query
   */
  public io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryDefinition> getPreparedQuery(java.lang.String id) { 
    io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryDefinition> ret = delegate.getPreparedQuery(id).map(val -> val);
    return ret;
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return a future provided with definition of the prepare query
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryDefinition> rxGetPreparedQuery(java.lang.String id) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getPreparedQuery(id).onComplete($handler);
    });
  }

  /**
   * Returns a list of all prepared queries.
   * @return a future provided with list of definitions of the all prepare queries
   */
  public io.vertx.core.Future<java.util.List<io.vertx.ext.consul.PreparedQueryDefinition>> getAllPreparedQueries() { 
    io.vertx.core.Future<java.util.List<io.vertx.ext.consul.PreparedQueryDefinition>> ret = delegate.getAllPreparedQueries().map(val -> val);
    return ret;
  }

  /**
   * Returns a list of all prepared queries.
   * @return a future provided with list of definitions of the all prepare queries
   */
  public io.reactivex.Single<java.util.List<io.vertx.ext.consul.PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getAllPreparedQueries().onComplete($handler);
    });
  }

  /**
   * @param definition definition of the prepare query
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.updatePreparedQuery(definition).map(val -> val);
    return ret;
  }

  /**
   * @param definition definition of the prepare query
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxUpdatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition definition) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.updatePreparedQuery(definition).onComplete($handler);
    });
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> deletePreparedQuery(java.lang.String id) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deletePreparedQuery(id).map(val -> val);
    return ret;
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDeletePreparedQuery(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deletePreparedQuery(id).onComplete($handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return a future provided with response
   */
  public io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryExecuteResponse> executePreparedQuery(java.lang.String query) { 
    io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryExecuteResponse> ret = delegate.executePreparedQuery(query).map(val -> val);
    return ret;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return a future provided with response
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQuery(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.executePreparedQuery(query).onComplete($handler);
    });
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return a future provided with response
   */
  public io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryExecuteResponse> executePreparedQueryWithOptions(java.lang.String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    io.vertx.core.Future<io.vertx.ext.consul.PreparedQueryExecuteResponse> ret = delegate.executePreparedQueryWithOptions(query, options).map(val -> val);
    return ret;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return a future provided with response
   */
  public io.reactivex.Single<io.vertx.ext.consul.PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(java.lang.String query, io.vertx.ext.consul.PreparedQueryExecuteOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.executePreparedQueryWithOptions(query, options).onComplete($handler);
    });
  }

  /**
   * Register node with external service
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return a future provided with response
   */
  public io.vertx.core.Future<java.lang.Void> registerCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.registerCatalogService(nodeOptions, serviceOptions).map(val -> val);
    return ret;
  }

  /**
   * Register node with external service
   * @param nodeOptions the options of new node
   * @param serviceOptions the options of new service
   * @return a future provided with response
   */
  public io.reactivex.Completable rxRegisterCatalogService(io.vertx.ext.consul.Node nodeOptions, io.vertx.ext.consul.ServiceOptions serviceOptions) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.registerCatalogService(nodeOptions, serviceOptions).onComplete($handler);
    });
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return a future notified when complete
   */
  public io.vertx.core.Future<java.lang.Void> deregisterCatalogService(java.lang.String nodeId, java.lang.String serviceId) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.deregisterCatalogService(nodeId, serviceId).map(val -> val);
    return ret;
  }

  /**
   * Deregister entities from the node or deregister the node itself.
   * @param nodeId the ID of node
   * @param serviceId the ID of the service to de-registered; if it is null, the node itself will be de-registered (as well as the entities that belongs to that node)
   * @return a future notified when complete
   */
  public io.reactivex.Completable rxDeregisterCatalogService(java.lang.String nodeId, java.lang.String serviceId) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.deregisterCatalogService(nodeId, serviceId).onComplete($handler);
    });
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }

  public static ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }

}
