/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.webauthn4j;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating WebAuthN based {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.webauthn4j.WebAuthn4J original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.webauthn4j.WebAuthn4J.class)
public class WebAuthn4J extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebAuthn4J that = (WebAuthn4J) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebAuthn4J> __TYPE_ARG = new TypeArg<>(    obj -> new WebAuthn4J((io.vertx.ext.auth.webauthn4j.WebAuthn4J) obj),
    WebAuthn4J::getDelegate
  );

  private final io.vertx.ext.auth.webauthn4j.WebAuthn4J delegate;
  
  public WebAuthn4J(io.vertx.ext.auth.webauthn4j.WebAuthn4J delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WebAuthn4J(Object delegate) {
    super((io.vertx.ext.auth.webauthn4j.WebAuthn4J)delegate);
    this.delegate = (io.vertx.ext.auth.webauthn4j.WebAuthn4J)delegate;
  }

  @Override 
  public io.vertx.ext.auth.webauthn4j.WebAuthn4J getDelegate() {
    return delegate;
  }


  /**
   * Create a WebAuthN auth provider
   * @param vertx the Vertx instance.
   * @return the auth provider.
   */
  public static io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J ret = io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J.newInstance((io.vertx.ext.auth.webauthn4j.WebAuthn4J)io.vertx.ext.auth.webauthn4j.WebAuthn4J.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a WebAuthN auth provider
   * @param vertx the Vertx instance.
   * @param options the custom options to the provider.
   * @return the auth provider.
   */
  public static io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J create(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.webauthn4j.WebAuthn4JOptions options) { 
    io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J ret = io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J.newInstance((io.vertx.ext.auth.webauthn4j.WebAuthn4J)io.vertx.ext.auth.webauthn4j.WebAuthn4J.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   * <p>
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param user - the user object with name and optionally displayName and icon
   * @return a future notified with the encoded make credentials request
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> createCredentialsOptions(io.vertx.core.json.JsonObject user) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.createCredentialsOptions(user).map(val -> val);
    return ret;
  }

  /**
   * Gets a challenge and any other parameters for the <code>navigator.credentials.create()</code> call.
   * <p>
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param user - the user object with name and optionally displayName and icon
   * @return a future notified with the encoded make credentials request
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxCreateCredentialsOptions(io.vertx.core.json.JsonObject user) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.createCredentialsOptions(user).onComplete($handler);
    });
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   * <p>
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param username the unique user identified
   * @return a future notified with the server encoded get assertion request
   */
  public io.vertx.core.Future<io.vertx.core.json.JsonObject> getCredentialsOptions(java.lang.String username) { 
    io.vertx.core.Future<io.vertx.core.json.JsonObject> ret = delegate.getCredentialsOptions(username).map(val -> val);
    return ret;
  }

  /**
   * Creates an assertion challenge and any other parameters for the <code>navigator.credentials.get()</code> call.
   * If the auth provider is configured with <code>RequireResidentKey</code> and the username is null then the
   * generated assertion will be a RK assertion (Usernameless).
   * <p>
   * The object being returned is described here <a href="https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions">https://w3c.github.io/webauthn/#dictdef-publickeycredentialcreationoptions</a>
   * @param username the unique user identified
   * @return a future notified with the server encoded get assertion request
   */
  public io.reactivex.Single<io.vertx.core.json.JsonObject> rxGetCredentialsOptions(java.lang.String username) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.getCredentialsOptions(username).onComplete($handler);
    });
  }

  /**
   * Provide a {@link io.vertx.reactivex.ext.auth.webauthn4j.CredentialStorage} that can fetch {@link io.vertx.ext.auth.webauthn4j.Authenticator}s from storage and update them.
   * @param credentialStorage the storage abstraction for credentials.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.webauthn4j.WebAuthn4J credentialStorage(io.vertx.reactivex.ext.auth.webauthn4j.CredentialStorage credentialStorage) { 
    delegate.credentialStorage(credentialStorage.getDelegate());
    return this;
  }

  public static WebAuthn4J newInstance(io.vertx.ext.auth.webauthn4j.WebAuthn4J arg) {
    return arg != null ? new WebAuthn4J(arg) : null;
  }

}
