/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.properties;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating property file based {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.properties.PropertyFileAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.properties.PropertyFileAuthorization.class)
public class PropertyFileAuthorization implements RxDelegate, io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PropertyFileAuthorization that = (PropertyFileAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PropertyFileAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new PropertyFileAuthorization((io.vertx.ext.auth.properties.PropertyFileAuthorization) obj),
    PropertyFileAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.properties.PropertyFileAuthorization delegate;
  
  public PropertyFileAuthorization(io.vertx.ext.auth.properties.PropertyFileAuthorization delegate) {
    this.delegate = delegate;
  }

  public PropertyFileAuthorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.properties.PropertyFileAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.properties.PropertyFileAuthorization getDelegate() {
    return delegate;
  }


  /**
   * returns the id of the authorization provider
   * @return 
   */
  public java.lang.String getId() { 
    java.lang.String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.vertx.core.Future<java.lang.Void> getAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.getAuthorizations(user.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.getAuthorizations(user).onComplete($handler);
    });
  }

  /**
   * Create a File authentication provider
   * @param vertx the Vert.x instance
   * @param path 
   * @return the authentication provider
   */
  public static io.vertx.reactivex.ext.auth.properties.PropertyFileAuthorization create(io.vertx.reactivex.core.Vertx vertx, java.lang.String path) { 
    io.vertx.reactivex.ext.auth.properties.PropertyFileAuthorization ret = io.vertx.reactivex.ext.auth.properties.PropertyFileAuthorization.newInstance((io.vertx.ext.auth.properties.PropertyFileAuthorization)io.vertx.ext.auth.properties.PropertyFileAuthorization.create(vertx.getDelegate(), path));
    return ret;
  }

  public static PropertyFileAuthorization newInstance(io.vertx.ext.auth.properties.PropertyFileAuthorization arg) {
    return arg != null ? new PropertyFileAuthorization(arg) : null;
  }

}
