/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.otp;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Otp key generator.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.otp.OtpKeyGenerator original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.otp.OtpKeyGenerator.class)
public class OtpKeyGenerator implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OtpKeyGenerator that = (OtpKeyGenerator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OtpKeyGenerator> __TYPE_ARG = new TypeArg<>(    obj -> new OtpKeyGenerator((io.vertx.ext.auth.otp.OtpKeyGenerator) obj),
    OtpKeyGenerator::getDelegate
  );

  private final io.vertx.ext.auth.otp.OtpKeyGenerator delegate;
  
  public OtpKeyGenerator(io.vertx.ext.auth.otp.OtpKeyGenerator delegate) {
    this.delegate = delegate;
  }

  public OtpKeyGenerator(Object delegate) {
    this.delegate = (io.vertx.ext.auth.otp.OtpKeyGenerator)delegate;
  }

  @Override 
  public io.vertx.ext.auth.otp.OtpKeyGenerator getDelegate() {
    return delegate;
  }

  /**
   * Generate key with default size;
   * @return {@link io.vertx.ext.auth.otp.OtpKey}
   */
  public io.vertx.ext.auth.otp.OtpKey generate() { 
    io.vertx.ext.auth.otp.OtpKey ret = delegate.generate();
    return ret;
  }

  /**
   * Generate key
   * @param keySize size of key
   * @return {@link io.vertx.ext.auth.otp.OtpKey}
   */
  public io.vertx.ext.auth.otp.OtpKey generate(int keySize) { 
    io.vertx.ext.auth.otp.OtpKey ret = delegate.generate(keySize);
    return ret;
  }

  public java.lang.String getAlgorithm() { 
    java.lang.String ret = delegate.getAlgorithm();
    return ret;
  }

  /**
   * Creates an instance of OtpKeyGenerator.
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator}.
   */
  public static io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator create() { 
    io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator ret = io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator.newInstance((io.vertx.ext.auth.otp.OtpKeyGenerator)io.vertx.ext.auth.otp.OtpKeyGenerator.create());
    return ret;
  }

  /**
   * Creates an instance of OtpKeyGenerator.
   * @param algorithm used hash algorithm.
   * @return the created instance of {@link io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator}.
   */
  public static io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator create(java.lang.String algorithm) { 
    io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator ret = io.vertx.reactivex.ext.auth.otp.OtpKeyGenerator.newInstance((io.vertx.ext.auth.otp.OtpKeyGenerator)io.vertx.ext.auth.otp.OtpKeyGenerator.create(algorithm));
    return ret;
  }

  public static OtpKeyGenerator newInstance(io.vertx.ext.auth.otp.OtpKeyGenerator arg) {
    return arg != null ? new OtpKeyGenerator(arg) : null;
  }

}
