/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for Instagram.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.InstagramAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.InstagramAuth.class)
public class InstagramAuth implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    InstagramAuth that = (InstagramAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<InstagramAuth> __TYPE_ARG = new TypeArg<>(    obj -> new InstagramAuth((io.vertx.ext.auth.oauth2.providers.InstagramAuth) obj),
    InstagramAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.InstagramAuth delegate;
  
  public InstagramAuth(io.vertx.ext.auth.oauth2.providers.InstagramAuth delegate) {
    this.delegate = delegate;
  }

  public InstagramAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.InstagramAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.oauth2.providers.InstagramAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for Instagram
   * @param vertx 
   * @param clientId the client id given to you by Instagram
   * @param clientSecret the client secret given to you by Instagram
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.InstagramAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Instagram
   * @param vertx 
   * @param clientId the client id given to you by Instagram
   * @param clientSecret the client secret given to you by Instagram
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.InstagramAuth.create(vertx.getDelegate(), clientId, clientSecret, httpClientOptions));
    return ret;
  }

  public static InstagramAuth newInstance(io.vertx.ext.auth.oauth2.providers.InstagramAuth arg) {
    return arg != null ? new InstagramAuth(arg) : null;
  }

}
