/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.providers;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for Apple.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.AppleIdAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.AppleIdAuth.class)
public class AppleIdAuth extends io.vertx.reactivex.ext.auth.oauth2.providers.OpenIDConnectAuth implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AppleIdAuth that = (AppleIdAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AppleIdAuth> __TYPE_ARG = new TypeArg<>(    obj -> new AppleIdAuth((io.vertx.ext.auth.oauth2.providers.AppleIdAuth) obj),
    AppleIdAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.AppleIdAuth delegate;
  
  public AppleIdAuth(io.vertx.ext.auth.oauth2.providers.AppleIdAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AppleIdAuth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.providers.AppleIdAuth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.providers.AppleIdAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.oauth2.providers.AppleIdAuth getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth>(o1 -> io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)o1), o1 -> o1.getDelegate());

  /**
   * Create a OAuth2Auth provider for Apple
   * @param vertx 
   * @param clientId the client id given to you by Apple
   * @param teamId the team id given to you by Apple
   * @param privateKey The private key for the client. This is the private key you generated when creating the
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientId, java.lang.String teamId, io.vertx.ext.auth.PubSecKeyOptions privateKey) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.AppleIdAuth.create(vertx.getDelegate(), clientId, teamId, privateKey));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for Apple
   * @param vertx 
   * @param clientId Client ID (also known as the Services ID in Apple's Developer Portal).
   * @param teamId Team ID for the Apple Developer Account found on top right corner of the developers page
   * @param privateKey The private key for the client. This is the private key you generated when creating the App id. With the identifier for the private key at Apple
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth create(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientId, java.lang.String teamId, io.vertx.ext.auth.PubSecKeyOptions privateKey, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth ret = io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.AppleIdAuth.create(vertx.getDelegate(), clientId, teamId, privateKey, httpClientOptions));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param privateKey 
   * @param config the initial config
   * @return future with instantiated Oauth2 provider instance handler
   */
  public static io.vertx.core.Future<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> discover(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.PubSecKeyOptions privateKey, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> ret = io.vertx.ext.auth.oauth2.providers.AppleIdAuth.discover(vertx.getDelegate(), privateKey, config).map(val -> io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)val));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
   * configuration options and attempt to load the well known descriptor. If a site is provided (for example when
   * running on a custom instance) that site will be used to do the lookup.
   * <p>
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param privateKey 
   * @param config the initial config
   * @return future with instantiated Oauth2 provider instance handler
   */
  public static io.reactivex.Single<io.vertx.reactivex.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.reactivex.core.Vertx vertx, io.vertx.ext.auth.PubSecKeyOptions privateKey, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    return AsyncResultSingle.toSingle($handler -> {
      io.vertx.reactivex.ext.auth.oauth2.providers.AppleIdAuth.discover(vertx, privateKey, config).onComplete($handler);
    });
  }

  public static AppleIdAuth newInstance(io.vertx.ext.auth.oauth2.providers.AppleIdAuth arg) {
    return arg != null ? new AppleIdAuth(arg) : null;
  }

}
