/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.oauth2.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Scope is a mechanism in OAuth 2.0 to limit an application's access to a user's account.
 * An application can request one or more scopes, this information is then presented to the
 * user in the consent screen, and the access token issued to the application will be
 * limited to the scopes granted.
 * <p>
 * The OAuth spec allows the authorization server or user to modify the scopes granted to
 * the application compared to what is requested, although there are not many examples of
 * services doing this in practice.
 * <p>
 * OAuth2 does not define any particular values for scopes, since it is highly dependent
 * on the service's internal architecture and needs.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.class)
public class ScopeAuthorization implements RxDelegate, io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ScopeAuthorization that = (ScopeAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ScopeAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new ScopeAuthorization((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization) obj),
    ScopeAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization delegate;
  
  public ScopeAuthorization(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization delegate) {
    this.delegate = delegate;
  }

  public ScopeAuthorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization getDelegate() {
    return delegate;
  }


  /**
   * returns the id of the authorization provider
   * @return 
   */
  public java.lang.String getId() { 
    java.lang.String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.vertx.core.Future<java.lang.Void> getAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.getAuthorizations(user.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.getAuthorizations(user).onComplete($handler);
    });
  }

  /**
   * Factory method to create a Authorization provider for Oauth 2.0 scopes using the default separator <code>" "</code>.
   * @return a AuthorizationProvider
   */
  public static io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization create() { 
    io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create());
    return ret;
  }

  /**
   * Factory method to create a Authorization provider for Oauth 2.0 scopes.
   * @param scopeSeparator the scope separator e.g.: <code>" "</code>, <code>","</code>, <code>"+"</code>
   * @return a AuthorizationProvider
   */
  public static io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization create(java.lang.String scopeSeparator) { 
    io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create(scopeSeparator));
    return ret;
  }

  /**
   * Factory method to create a Authorization provider for OpenID Connect scopes. The claim key will be used to locate
   * the scopes from a decoded JWT.
   * @param scopeSeparator the scope separator e.g.: <code>" "</code>, <code>","</code>, <code>"+"</code>
   * @param claimKey the scope claim key e.g.: <code>"scp"</code>, <code>"scope"</code>
   * @return a AuthorizationProvider
   */
  public static io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization create(java.lang.String scopeSeparator, java.lang.String claimKey) { 
    io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization ret = io.vertx.reactivex.ext.auth.oauth2.authorization.ScopeAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization)io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization.create(scopeSeparator, claimKey));
    return ret;
  }

  /**
   * Returns the configured separator.
   * @return the separator.
   */
  public java.lang.String separator() { 
    java.lang.String ret = delegate.separator();
    return ret;
  }

  /**
   * Returns the configured claim key.
   * @return the claim key.
   */
  public java.lang.String claimKey() { 
    java.lang.String ret = delegate.claimKey();
    return ret;
  }

  /**
   * Returns a String with the given scopes concatenated with the given separator.
   * @param scopes a list of scopes
   * @return concatenated string.
   */
  public java.lang.String encode(java.util.List<java.lang.String> scopes) { 
    java.lang.String ret = delegate.encode(scopes);
    return ret;
  }

  public static ScopeAuthorization newInstance(io.vertx.ext.auth.oauth2.authorization.ScopeAuthorization arg) {
    return arg != null ? new ScopeAuthorization(arg) : null;
  }

}
