/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jwt.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Implementation of the Microprofile MP-JWT 1.1 RBAC based on the access token groups key.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization.class)
public class MicroProfileAuthorization implements RxDelegate, io.vertx.reactivex.ext.auth.authorization.AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MicroProfileAuthorization that = (MicroProfileAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MicroProfileAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new MicroProfileAuthorization((io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization) obj),
    MicroProfileAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization delegate;
  
  public MicroProfileAuthorization(io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization delegate) {
    this.delegate = delegate;
  }

  public MicroProfileAuthorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization getDelegate() {
    return delegate;
  }


  /**
   * returns the id of the authorization provider
   * @return 
   */
  public java.lang.String getId() { 
    java.lang.String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.vertx.core.Future<java.lang.Void> getAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.getAuthorizations(user.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.getAuthorizations(user).onComplete($handler);
    });
  }

  /**
   * Factory method to create a Authorization provider for tokens adhering to the MP-JWT 1.1 spec.
   * When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
   * is expected to be extracted from  under the key <code>accessToken</code>.
   * @return a AuthorizationProvider
   */
  public static io.vertx.reactivex.ext.auth.jwt.authorization.MicroProfileAuthorization create() { 
    io.vertx.reactivex.ext.auth.jwt.authorization.MicroProfileAuthorization ret = io.vertx.reactivex.ext.auth.jwt.authorization.MicroProfileAuthorization.newInstance((io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization)io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization.create());
    return ret;
  }

  public static MicroProfileAuthorization newInstance(io.vertx.ext.auth.jwt.authorization.MicroProfileAuthorization arg) {
    return arg != null ? new MicroProfileAuthorization(arg) : null;
  }

}
