/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a permission Note that the permission can optionally be assigned
 * to a specific resource
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.PermissionBasedAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.PermissionBasedAuthorization.class)
public class PermissionBasedAuthorization implements RxDelegate, io.vertx.reactivex.ext.auth.authorization.Authorization {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PermissionBasedAuthorization that = (PermissionBasedAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PermissionBasedAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new PermissionBasedAuthorization((io.vertx.ext.auth.authorization.PermissionBasedAuthorization) obj),
    PermissionBasedAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.PermissionBasedAuthorization delegate;
  
  public PermissionBasedAuthorization(io.vertx.ext.auth.authorization.PermissionBasedAuthorization delegate) {
    this.delegate = delegate;
  }

  public PermissionBasedAuthorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.PermissionBasedAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.PermissionBasedAuthorization getDelegate() {
    return delegate;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * context.
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.reactivex.ext.auth.authorization.AuthorizationContext context) { 
    boolean ret = delegate.match(context.getDelegate());
    return ret;
  }

  /**
   * this method verifies whether or not the authorization implies the specified
   * authorization.
   * </br>Note that it doesn't always mean an exact match. For instance,
   * in the case of a {@link io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization}, this method
   * may return true even if the permissions are different
   * </br>WildcardPermissionBasedAuthorization.create('*').verify(WildcardPermissionBasedAuthorization.create('anypermission'))
   * would return true
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.reactivex.ext.auth.authorization.Authorization authorization) { 
    boolean ret = delegate.verify(authorization.getDelegate());
    return ret;
  }

  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  public static io.vertx.reactivex.ext.auth.authorization.PermissionBasedAuthorization create(java.lang.String permission) { 
    io.vertx.reactivex.ext.auth.authorization.PermissionBasedAuthorization ret = io.vertx.reactivex.ext.auth.authorization.PermissionBasedAuthorization.newInstance((io.vertx.ext.auth.authorization.PermissionBasedAuthorization)io.vertx.ext.auth.authorization.PermissionBasedAuthorization.create(permission));
    return ret;
  }

  /**
   * returns the value of the permission
   * @return 
   */
  public java.lang.String getPermission() { 
    java.lang.String ret = delegate.getPermission();
    return ret;
  }

  /**
   * returns an optional resource that the permission is assigned-on
   * @return 
   */
  public java.lang.String getResource() { 
    java.lang.String ret = delegate.getResource();
    return ret;
  }

  /**
   * sets an optional resource that the permission is assigned-on
   * @param resource 
   * @return 
   */
  public io.vertx.reactivex.ext.auth.authorization.PermissionBasedAuthorization setResource(java.lang.String resource) { 
    delegate.setResource(resource);
    return this;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * user. Internally a basic context is created with the user and the method
   * delegates to {@link io.vertx.reactivex.ext.auth.authorization.Authorization#match}
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.reactivex.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

  public static PermissionBasedAuthorization newInstance(io.vertx.ext.auth.authorization.PermissionBasedAuthorization arg) {
    return arg != null ? new PermissionBasedAuthorization(arg) : null;
  }

}
