/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Allows to perform a logical 'or' between several authorizations
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.OrAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.OrAuthorization.class)
public class OrAuthorization implements RxDelegate, io.vertx.reactivex.ext.auth.authorization.Authorization {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrAuthorization that = (OrAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OrAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new OrAuthorization((io.vertx.ext.auth.authorization.OrAuthorization) obj),
    OrAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.authorization.OrAuthorization delegate;
  
  public OrAuthorization(io.vertx.ext.auth.authorization.OrAuthorization delegate) {
    this.delegate = delegate;
  }

  public OrAuthorization(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.OrAuthorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.OrAuthorization getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.auth.authorization.Authorization> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.auth.authorization.Authorization>(o1 -> io.vertx.reactivex.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)o1), o1 -> o1.getDelegate());

  /**
   * this methods verifies whether or not the authorization match the specified
   * context.
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.reactivex.ext.auth.authorization.AuthorizationContext context) { 
    boolean ret = delegate.match(context.getDelegate());
    return ret;
  }

  /**
   * this method verifies whether or not the authorization implies the specified
   * authorization.
   * </br>Note that it doesn't always mean an exact match. For instance,
   * in the case of a {@link io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization}, this method
   * may return true even if the permissions are different
   * </br>WildcardPermissionBasedAuthorization.create('*').verify(WildcardPermissionBasedAuthorization.create('anypermission'))
   * would return true
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.reactivex.ext.auth.authorization.Authorization authorization) { 
    boolean ret = delegate.verify(authorization.getDelegate());
    return ret;
  }

  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  public static io.vertx.reactivex.ext.auth.authorization.OrAuthorization create() { 
    io.vertx.reactivex.ext.auth.authorization.OrAuthorization ret = io.vertx.reactivex.ext.auth.authorization.OrAuthorization.newInstance((io.vertx.ext.auth.authorization.OrAuthorization)io.vertx.ext.auth.authorization.OrAuthorization.create());
    return ret;
  }

  public java.util.List<io.vertx.reactivex.ext.auth.authorization.Authorization> getAuthorizations() { 
    java.util.List<io.vertx.reactivex.ext.auth.authorization.Authorization> ret = delegate.getAuthorizations().stream().map(elt -> io.vertx.reactivex.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)elt)).collect(Collectors.toList());
    return ret;
  }

  public io.vertx.reactivex.ext.auth.authorization.OrAuthorization addAuthorization(io.vertx.reactivex.ext.auth.authorization.Authorization authorization) { 
    io.vertx.reactivex.ext.auth.authorization.OrAuthorization ret = io.vertx.reactivex.ext.auth.authorization.OrAuthorization.newInstance((io.vertx.ext.auth.authorization.OrAuthorization)delegate.addAuthorization(authorization.getDelegate()));
    return ret;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * user. Internally a basic context is created with the user and the method
   * delegates to {@link io.vertx.reactivex.ext.auth.authorization.Authorization#match}
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.reactivex.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

  public static OrAuthorization newInstance(io.vertx.ext.auth.authorization.OrAuthorization arg) {
    return arg != null ? new OrAuthorization(arg) : null;
  }

}
