/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a cache map of authorizations per provider.
 *
 * Authorizations are immutable and can be shared between users.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.Authorizations original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.Authorizations.class)
public class Authorizations implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Authorizations that = (Authorizations) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Authorizations> __TYPE_ARG = new TypeArg<>(    obj -> new Authorizations((io.vertx.ext.auth.authorization.Authorizations) obj),
    Authorizations::getDelegate
  );

  private final io.vertx.ext.auth.authorization.Authorizations delegate;
  
  public Authorizations(io.vertx.ext.auth.authorization.Authorizations delegate) {
    this.delegate = delegate;
  }

  public Authorizations(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorizations)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.Authorizations getDelegate() {
    return delegate;
  }

  /**
   * Replaces the current authorizations with the given authorizations for the given provider.
   * @param providerId the provider.
   * @param authorizations the new map of authorizations. <code>null</code> is equivalent to remove all authorizations for the given provider.
   * @return fluent self.
   */
  public io.vertx.reactivex.ext.auth.authorization.Authorizations put(java.lang.String providerId, java.util.Set<io.vertx.reactivex.ext.auth.authorization.Authorization> authorizations) { 
    delegate.put(providerId, authorizations.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()));
    return this;
  }

  /**
   * <code>true</code> if the authorizations contains at least one provider.
   * @return 
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * Clears the authorizations.
   * @return 
   */
  public io.vertx.reactivex.ext.auth.authorization.Authorizations clear() { 
    delegate.clear();
    return this;
  }

  /**
   * Logical check if the this object contains the given provider id
   * @param providerId the provider to search for.
   * @return <code>true</code> when the provider is present.
   */
  public boolean contains(java.lang.String providerId) { 
    boolean ret = delegate.contains(providerId);
    return ret;
  }

  /**
   * Verifies that the given authorization is present in the authorizations.
   * @param resolvedAuthorization the authorization to verify.
   * @return <code>true</code> if the authorization is present.
   */
  public boolean verify(io.vertx.reactivex.ext.auth.authorization.Authorization resolvedAuthorization) { 
    boolean ret = delegate.verify(resolvedAuthorization.getDelegate());
    return ret;
  }

  public static Authorizations newInstance(io.vertx.ext.auth.authorization.Authorizations arg) {
    return arg != null ? new Authorizations(arg) : null;
  }

}
