/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The role of an AuthorizationProvider is to return a set of Authorization.
 * Note that each AuthorizationProvider must provide its own unique Id
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.AuthorizationProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.AuthorizationProvider.class)
public interface AuthorizationProvider extends RxDelegate {

  @Override 
  io.vertx.ext.auth.authorization.AuthorizationProvider getDelegate();

  /**
   * returns the id of the authorization provider
   * @return 
   */
  public java.lang.String getId();

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.vertx.core.Future<java.lang.Void> getAuthorizations(io.vertx.reactivex.ext.auth.User user);

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user);

  public static AuthorizationProvider newInstance(io.vertx.ext.auth.authorization.AuthorizationProvider arg) {
    return arg != null ? new AuthorizationProviderImpl(arg) : null;
  }

}

class AuthorizationProviderImpl implements AuthorizationProvider {
  private final io.vertx.ext.auth.authorization.AuthorizationProvider delegate;
  
  public AuthorizationProviderImpl(io.vertx.ext.auth.authorization.AuthorizationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthorizationProviderImpl(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.AuthorizationProvider)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.AuthorizationProvider getDelegate() {
    return delegate;
  }


  /**
   * returns the id of the authorization provider
   * @return 
   */
  public java.lang.String getId() { 
    java.lang.String ret = delegate.getId();
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.vertx.core.Future<java.lang.Void> getAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    io.vertx.core.Future<java.lang.Void> ret = delegate.getAuthorizations(user.getDelegate()).map(val -> val);
    return ret;
  }

  /**
   * Updates the user with the set of authorizations.
   * @param user user to lookup and update.
   * @return Future void to signal end of asynchronous call.
   */
  public io.reactivex.Completable rxGetAuthorizations(io.vertx.reactivex.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable($handler -> {
      this.getAuthorizations(user).onComplete($handler);
    });
  }

}
