/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authorization;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface representing any kind of authorization such as:
 * <ul>
 *   <li>Role based authorization
 *   <li>Permission based authorization
 *   <li>Logical authorization (AND, OR, NOT)
 *   <li>Time based authorization (ie: allow access the last 5 days of the month, from 8am till 10am, etc.)
 *   <li>Context based authorization (ie: allow access if the ip address is 'xxx.xxx.xxx.xxx')
 *   <li>Custom based authorization (ie: based on a script or hard-coded code specific to an application)
 *   <li>etc.
 * </ul>
 * The following implementations are provided out of the box:
 * <ul>
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.AndAuthorization}
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.NotAuthorization}
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.OrAuthorization}
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.PermissionBasedAuthorization}
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.RoleBasedAuthorization}
 *   <li>{@link io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization}
 * </ul>
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authorization.Authorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authorization.Authorization.class)
public interface Authorization extends RxDelegate {

  @Override 
  io.vertx.ext.auth.authorization.Authorization getDelegate();

  /**
   * this methods verifies whether or not the authorization match the specified
   * context.
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.reactivex.ext.auth.authorization.AuthorizationContext context);

  /**
   * this method verifies whether or not the authorization implies the specified
   * authorization.
   * </br>Note that it doesn't always mean an exact match. For instance,
   * in the case of a {@link io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization}, this method
   * may return true even if the permissions are different
   * </br>WildcardPermissionBasedAuthorization.create('*').verify(WildcardPermissionBasedAuthorization.create('anypermission'))
   * would return true
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.reactivex.ext.auth.authorization.Authorization authorization);

  public io.vertx.core.json.JsonObject toJson();

  public static Authorization newInstance(io.vertx.ext.auth.authorization.Authorization arg) {
    return arg != null ? new AuthorizationImpl(arg) : null;
  }

}

class AuthorizationImpl implements Authorization {
  private final io.vertx.ext.auth.authorization.Authorization delegate;
  
  public AuthorizationImpl(io.vertx.ext.auth.authorization.Authorization delegate) {
    this.delegate = delegate;
  }

  public AuthorizationImpl(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorization)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.Authorization getDelegate() {
    return delegate;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * context.
   * @param context the context.
   * @return true if there's a match.
   */
  public boolean match(io.vertx.reactivex.ext.auth.authorization.AuthorizationContext context) { 
    boolean ret = delegate.match(context.getDelegate());
    return ret;
  }

  /**
   * this method verifies whether or not the authorization implies the specified
   * authorization.
   * </br>Note that it doesn't always mean an exact match. For instance,
   * in the case of a {@link io.vertx.reactivex.ext.auth.authorization.WildcardPermissionBasedAuthorization}, this method
   * may return true even if the permissions are different
   * </br>WildcardPermissionBasedAuthorization.create('*').verify(WildcardPermissionBasedAuthorization.create('anypermission'))
   * would return true
   * @param authorization the authorization.
   * @return true if implies the argument.
   */
  public boolean verify(io.vertx.reactivex.ext.auth.authorization.Authorization authorization) { 
    boolean ret = delegate.verify(authorization.getDelegate());
    return ret;
  }

  public io.vertx.core.json.JsonObject toJson() { 
    io.vertx.core.json.JsonObject ret = delegate.toJson();
    return ret;
  }

  /**
   * this methods verifies whether or not the authorization match the specified
   * user. Internally a basic context is created with the user and the method
   * delegates to {@link io.vertx.reactivex.ext.auth.authorization.Authorization#match}
   * @param user the user.
   * @return true if there's a match
   */
  public boolean match(io.vertx.reactivex.ext.auth.User user) { 
    boolean ret = delegate.match(user.getDelegate());
    return ret;
  }

}
