/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.authentication;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * User-facing interface for authenticating users.
 *
 * <p>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.authentication.AuthenticationProvider original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.authentication.AuthenticationProvider.class)
public class AuthenticationProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AuthenticationProvider that = (AuthenticationProvider) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AuthenticationProvider> __TYPE_ARG = new TypeArg<>(    obj -> new AuthenticationProvider((io.vertx.ext.auth.authentication.AuthenticationProvider) obj),
    AuthenticationProvider::getDelegate
  );

  private final io.vertx.ext.auth.authentication.AuthenticationProvider delegate;
  
  public AuthenticationProvider(io.vertx.ext.auth.authentication.AuthenticationProvider delegate) {
    this.delegate = delegate;
  }

  public AuthenticationProvider(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authentication.AuthenticationProvider)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authentication.AuthenticationProvider getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.auth.User> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.auth.User>(o1 -> io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)o1), o1 -> o1.getDelegate());

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   * @param credentials The credentials
   * @return The result future
   */
  public io.vertx.core.Future<io.vertx.reactivex.ext.auth.User> authenticate(io.vertx.ext.auth.authentication.Credentials credentials) { 
    io.vertx.core.Future<io.vertx.reactivex.ext.auth.User> ret = delegate.authenticate(credentials).map(val -> io.vertx.reactivex.ext.auth.User.newInstance((io.vertx.ext.auth.User)val));
    return ret;
  }

  /**
   * Authenticate a user.
   * <p>
   * The first argument is a Credentials object containing information for authenticating the user.
   * What this actually contains depends on the specific implementation.
   * @param credentials The credentials
   * @return The result future
   */
  public io.reactivex.Single<io.vertx.reactivex.ext.auth.User> rxAuthenticate(io.vertx.ext.auth.authentication.Credentials credentials) { 
    return AsyncResultSingle.toSingle($handler -> {
      this.authenticate(credentials).onComplete($handler);
    });
  }

  public static AuthenticationProvider newInstance(io.vertx.ext.auth.authentication.AuthenticationProvider arg) {
    return arg != null ? new AuthenticationProvider(arg) : null;
  }

}
