/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.audit;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultFlowable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.auth.audit.SecurityAudit.class)
public class SecurityAudit implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityAudit that = (SecurityAudit) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SecurityAudit> __TYPE_ARG = new TypeArg<>(    obj -> new SecurityAudit((io.vertx.ext.auth.audit.SecurityAudit) obj),
    SecurityAudit::getDelegate
  );

  private final io.vertx.ext.auth.audit.SecurityAudit delegate;
  
  public SecurityAudit(io.vertx.ext.auth.audit.SecurityAudit delegate) {
    this.delegate = delegate;
  }

  public SecurityAudit(Object delegate) {
    this.delegate = (io.vertx.ext.auth.audit.SecurityAudit)delegate;
  }

  @Override 
  public io.vertx.ext.auth.audit.SecurityAudit getDelegate() {
    return delegate;
  }


  public static io.vertx.reactivex.ext.auth.audit.SecurityAudit create() { 
    io.vertx.reactivex.ext.auth.audit.SecurityAudit ret = io.vertx.reactivex.ext.auth.audit.SecurityAudit.newInstance((io.vertx.ext.auth.audit.SecurityAudit)io.vertx.ext.auth.audit.SecurityAudit.create());
    return ret;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit source(io.vertx.core.net.SocketAddress address) { 
    delegate.source(address);
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit destination(io.vertx.core.net.SocketAddress address) { 
    delegate.destination(address);
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit resource(io.vertx.core.http.HttpVersion version, io.vertx.core.http.HttpMethod method, java.lang.String path) { 
    io.vertx.reactivex.ext.auth.audit.SecurityAudit ret = io.vertx.reactivex.ext.auth.audit.SecurityAudit.newInstance((io.vertx.ext.auth.audit.SecurityAudit)delegate.resource(version, method, path));
    return ret;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit resource(java.lang.String resource) { 
    delegate.resource(resource);
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit credentials(io.vertx.ext.auth.authentication.Credentials credentials) { 
    delegate.credentials(credentials);
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit user(io.vertx.reactivex.ext.auth.User user) { 
    delegate.user(user.getDelegate());
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit authorization(io.vertx.reactivex.ext.auth.authorization.Authorization authorization) { 
    delegate.authorization(authorization.getDelegate());
    return this;
  }

  public io.vertx.reactivex.ext.auth.audit.SecurityAudit status(int status) { 
    delegate.status(status);
    return this;
  }

  public void audit(io.vertx.ext.auth.audit.Marker marker, boolean success) { 
    delegate.audit(marker, success);
  }

  public <T> io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> auditHandlerFor(io.vertx.ext.auth.audit.Marker marker) { 
    io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> ret = delegate.auditHandlerFor(marker);
    return ret;
  }

  public static final io.vertx.reactivex.ext.auth.audit.SecurityAudit NOOP = io.vertx.reactivex.ext.auth.audit.SecurityAudit.newInstance((io.vertx.ext.auth.audit.SecurityAudit)io.vertx.ext.auth.audit.SecurityAudit.NOOP);
  public static SecurityAudit newInstance(io.vertx.ext.auth.audit.SecurityAudit arg) {
    return arg != null ? new SecurityAudit(arg) : null;
  }

}
